/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.zzW9e;
import com.aspose.words.zzX46;
import com.aspose.words.zzXHT;
import com.aspose.words.zzXRE;
import com.aspose.words.zzZ0l;
import com.aspose.words.zzZqj;
import com.aspose.words.zzZwt;
import com.aspose.words.zzr2;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzXHT,
Iterable<T> {
    private Node zzXbb;
    private Node zzXAe;
    private Node zzWqu;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzYcj((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzYNv() {
        return this.zzYty() != null;
    }

    final boolean zzZ2t() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZ5L() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZ0l) {
                return true;
            }
            CompositeNode compositeNode = zzYlQ.zzYyt((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZ5L()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzXbb;
    }

    public Node getLastChild() {
        return this.zzXAe;
    }

    final Node zzYty() {
        return zzX46.zzWuI(this.getFirstChild(), false);
    }

    final Node zzYS1() {
        return zzX46.zzSU(this.getLastChild(), false);
    }

    final CompositeNode zzZcr() {
        return (CompositeNode)zzX46.zzWuI(this.getFirstChild(), true);
    }

    final CompositeNode zzZ17() {
        return (CompositeNode)zzX46.zzSU(this.getLastChild(), true);
    }

    final Node zzZVx() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzX46.zzWjy((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZEy() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzX46.zzWjy((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYyt(boolean bl, zzZqj zzZqj2) {
        CompositeNode compositeNode = (CompositeNode)super.zzYyt(bl, zzZqj2);
        ((CompositeNode)super.zzYyt(bl, zzZqj2)).zzXAe = null;
        compositeNode.zzXbb = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzYZc(node.zzYyt(true, zzZqj2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzVQ7(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzVQ7(StringBuilder stringBuilder) {
        this.zzje(stringBuilder);
        zzYlQ.zzYcj(stringBuilder, this.zzZZv());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYcj(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzX46.zzYaF(nodeType);
            Node node2 = node = bl ? this.zzYty() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZ7U() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXRE.zzWII(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXRE.zzUt(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZwt(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzYyt(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzYyt(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzYcj(oldChild, false);
    }

    private Node zzYcj(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzYyt(node, (Node)this, null, 1);
        if (documentBase.zzX2() && zzX46.zzX4j(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzYyt(nodeChangingArgs);
        }
        if (!bl && zzX46.zzY7M(node)) {
            zzX46.zzY7U(node, false);
        }
        Node node2 = this.zzWzT(node);
        if (nodeChangingArgs != null) {
            documentBase.zzYcj(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzW9e.zzYeI(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzYZc(Node node) {
        node.getParentNode();
        if (this.zzXAe == null) {
            node.zzZXK(null);
            node.zzZyw(null);
            this.zzXbb = node;
        } else {
            node.zzZXK(this.zzXAe);
            node.zzZyw(null);
            this.zzXAe.zzZyw(node);
        }
        this.zzXAe = node;
        node.zzYwQ(this);
        return node;
    }

    final void zzYyt(Node node, Node node2, Node node3) {
        this.zzYyt(node, node2, node3, false);
    }

    final void zzYyt(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzWCn(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYcj(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzWII(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzX46.zzWjy(node3.getNodeType())) continue;
            if (zzX46.zzXUn(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZZv().length();
    }

    String zzZZv() {
        return "";
    }

    final String zzWam() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzje(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzje(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzVQ7(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzYyt(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzYcj(visitor));
    }

    abstract int zzYyt(DocumentVisitor var1) throws Exception;

    abstract int zzYcj(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzWCn(Node var1);

    final Node zzYyt(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzWj7(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzWCn(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzr2(documentBase);
            try {
                compositeNode.zzYcj(node, true);
            }
            finally {
                ((zzr2)object).dispose();
            }
        }
        if ((object = documentBase.zzYyt(node, null, (Node)this, 0)) != null) {
            documentBase.zzYyt((NodeChangingArgs)object);
        }
        if (this.zzXAe == null) {
            node.zzZXK(null);
            node.zzZyw(null);
            this.zzXbb = node;
            this.zzXAe = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzYcj(node, node2);
            } else {
                this.zzWII(node, this.zzXbb);
            }
        } else if (node2 != null) {
            this.zzWII(node, node2);
        } else {
            this.zzYcj(node, this.zzXAe);
        }
        node.zzYwQ(this);
        if (object != null) {
            documentBase.zzYcj((NodeChangingArgs)object);
        }
        if (documentBase.zzX2()) {
            zzX46.zzYyt(node, compositeNode, node3);
        }
        return node;
    }

    private void zzYcj(Node node, Node node2) {
        Node node3 = node2.zzYjC();
        node.zzZXK(node2);
        node.zzZyw(node3);
        node2.zzZyw(node);
        if (node3 == null) {
            this.zzXAe = node;
            return;
        }
        node3.zzZXK(node);
    }

    private void zzWII(Node node, Node node2) {
        Node node3 = node2.zzXB5();
        node.zzZXK(node3);
        node.zzZyw(node2);
        node2.zzZXK(node);
        if (node3 == null) {
            this.zzXbb = node;
            return;
        }
        node3.zzZyw(node);
    }

    private Node zzWzT(Node node) {
        if (node == this.zzXbb) {
            if (this.zzXbb == this.zzXAe) {
                this.zzXbb = null;
                this.zzXAe = null;
            } else {
                this.zzXbb = node.zzYjC();
                this.zzXbb.zzZXK(null);
            }
        } else {
            Node node2 = node.zzXB5();
            Node node3 = node.zzYjC();
            node2.zzZyw(node3);
            if (node3 == null) {
                this.zzXAe = node2;
            } else {
                node3.zzZXK(node2);
            }
        }
        node.zzZyw(null);
        node.zzZXK(null);
        node.zzYwQ(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzWqu = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWqu;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

