/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzEw;
import com.aspose.words.internal.zzLM;
import com.aspose.words.internal.zzWEM;
import com.aspose.words.internal.zzWnS;
import com.aspose.words.internal.zzWw8;
import com.aspose.words.internal.zzXET;
import com.aspose.words.internal.zzXXJ;
import com.aspose.words.internal.zzXaN;
import com.aspose.words.internal.zzXhF;
import com.aspose.words.internal.zzXxR;
import com.aspose.words.internal.zzYAp;
import com.aspose.words.internal.zzYcb;
import com.aspose.words.internal.zzZV9;
import com.aspose.words.internal.zzZW2;
import com.aspose.words.internal.zzZdA;
import com.aspose.words.internal.zzZkL;
import com.aspose.words.internal.zzZod;
import com.aspose.words.internal.zzZot;
import com.aspose.words.internal.zzZuA;
import com.aspose.words.internal.zzkp;
import com.aspose.words.internal.zzxa;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzXxM
extends X509CRL {
    private final Provider zzZ4S;
    private final zzZot zzlg;
    private final String zzWL1;
    private final byte[] zzXEb;
    private final boolean zzWxk;
    private volatile boolean zzYBr = false;
    private volatile int zzYWR;

    static boolean zzZON(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(zzXaN.zzZHr.getId());
            return byArray != null && zzEw.zzva(zzZdA.zzFz(byArray).zzZuH()).zzVQH();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected zzXxM(Provider provider, zzZot zzZot2) throws CRLException {
        this.zzZ4S = provider;
        this.zzlg = zzZot2;
        try {
            this.zzWL1 = zzXhF.zzWsU(zzZot2.zzZ3B());
            this.zzXEb = (byte[])(zzZot2.zzZ3B().zzF7() != null ? zzZot2.zzZ3B().zzF7().zzXVg().getEncoded("DER") : null);
            this.zzWxk = zzXxM.zzZON(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(zzYAp.zzZSV);
        return !set.isEmpty();
    }

    private Set zzXC5(boolean bl) {
        zzWw8 zzWw82;
        if (this.getVersion() == 2 && (zzWw82 = this.zzlg.zzVUa().zzXAK()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzWw82.zzXA4();
            while (enumeration.hasMoreElements()) {
                zzZod zzZod2 = (zzZod)enumeration.nextElement();
                zzXaN zzXaN2 = zzWw82.zzX6s(zzZod2);
                if (bl != zzXaN2.isCritical()) continue;
                hashSet.add(zzZod2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public final Set getCriticalExtensionOIDs() {
        return this.zzXC5(true);
    }

    public final Set getNonCriticalExtensionOIDs() {
        return this.zzXC5(false);
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzXaN zzXaN2;
        zzWw8 zzWw82 = this.zzlg.zzVUa().zzXAK();
        if (zzWw82 != null && (zzXaN2 = zzWw82.zzX6s(new zzZod(oid))) != null) {
            try {
                return zzXaN2.zzZ3l().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public final byte[] getEncoded() throws CRLException {
        try {
            return this.zzlg.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.zzZ4S);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzWBj(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzWBj(key, signature);
    }

    private void zzWBj(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzlg.zzZ3B().equals(this.zzlg.zzVUa().zzWvJ())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.zzXEb != null) {
            try {
                zzXhF.zzWBj(signature, zzXxR.zzXy4(this.zzXEb));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public final int getVersion() {
        return this.zzlg.zzXVF();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzlg.zzXiN().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getThisUpdate() {
        return this.zzlg.zz2Q().zzW9Z();
    }

    @Override
    public final Date getNextUpdate() {
        if (this.zzlg.zzXzj() != null) {
            return this.zzlg.zzXzj().zzW9Z();
        }
        return null;
    }

    private Set zzX7V() {
        HashSet<zzZW2> hashSet = new HashSet<zzZW2>();
        Enumeration enumeration = this.zzlg.zzXI0();
        zzYcb zzYcb2 = null;
        while (enumeration.hasMoreElements()) {
            zzXaN zzXaN2;
            zzZV9.zzWBj zzWBj2 = (zzZV9.zzWBj)enumeration.nextElement();
            zzZW2 zzZW22 = new zzZW2(zzWBj2, this.zzWxk, zzYcb2);
            hashSet.add(zzZW22);
            if (!this.zzWxk || !zzWBj2.hasExtensions() || (zzXaN2 = zzWBj2.zzXAK().zzX6s(zzXaN.zzXB7)) == null) continue;
            zzYcb2 = zzYcb.zzXI6(zzkp.zzW3U(zzXaN2.zzWdQ()).zzWk4()[0].zzZZX());
        }
        return hashSet;
    }

    @Override
    public final X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzlg.zzXI0();
        zzYcb zzYcb2 = null;
        while (enumeration.hasMoreElements()) {
            zzXaN zzXaN2;
            zzZV9.zzWBj zzWBj2 = (zzZV9.zzWBj)enumeration.nextElement();
            if (serialNumber.equals(zzWBj2.zzZ3I().zzYjW())) {
                return new zzZW2(zzWBj2, this.zzWxk, zzYcb2);
            }
            if (!this.zzWxk || !zzWBj2.hasExtensions() || (zzXaN2 = zzWBj2.zzXAK().zzX6s(zzXaN.zzXB7)) == null) continue;
            zzYcb2 = zzYcb.zzXI6(zzkp.zzW3U(zzXaN2.zzWdQ()).zzWk4()[0].zzZZX());
        }
        return null;
    }

    public final Set getRevokedCertificates() {
        Set set = this.zzX7V();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public final byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzlg.zzVUa().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zzlg.zzY1r().zzZuH();
    }

    @Override
    public final String getSigAlgName() {
        return this.zzWL1;
    }

    @Override
    public final String getSigAlgOID() {
        return this.zzlg.zzZ3B().zzWI().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zzXEb != null) {
            byte[] byArray = new byte[this.zzXEb.length];
            System.arraycopy(this.zzXEb, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public final String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzWEM.zzY2u();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzWEM.zzfZ(zzxa.zzW01(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzWEM.zzfZ(zzxa.zzW01(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzWEM.zzfZ(zzxa.zzW01(byArray, i, byArray.length - i))).append(string);
        }
        zzWw8 zzWw82 = this.zzlg.zzVUa().zzXAK();
        if (zzWw82 != null) {
            object2 = zzWw82.zzXA4();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzZod)object2.nextElement();
                zzXaN zzXaN2 = zzWw82.zzX6s((zzZod)object);
                if (zzXaN2.zzZ3l() != null) {
                    byte[] byArray2 = zzXaN2.zzZ3l().zzZuH();
                    stringBuffer.append("                       critical(").append(zzXaN2.isCritical()).append(") ");
                    try {
                        zzXxR zzXxR2 = zzXxR.zzXy4(byArray2);
                        if (((zzXxR)object).equals(zzXaN.zzWGY)) {
                            stringBuffer.append(new zzZuA(zzXXJ.zzWTD(zzXxR2).zzWYy())).append(string);
                            continue;
                        }
                        if (((zzXxR)object).equals(zzXaN.zzK7)) {
                            stringBuffer.append("Base CRL: " + new zzZuA(zzXXJ.zzWTD(zzXxR2).zzWYy())).append(string);
                            continue;
                        }
                        if (((zzXxR)object).equals(zzXaN.zzZHr)) {
                            stringBuffer.append(zzEw.zzva(zzXxR2)).append(string);
                            continue;
                        }
                        if (((zzXxR)object).equals(zzXaN.zzYGI)) {
                            stringBuffer.append(zzLM.zzYrM(zzXxR2)).append(string);
                            continue;
                        }
                        if (((zzXxR)object).equals(zzXaN.zzFL)) {
                            stringBuffer.append(zzLM.zzYrM(zzXxR2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzZod)object).getId());
                        stringBuffer.append(" value = ").append(zzWnS.zzWBO(zzXxR2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzZod)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzlg.zzXI0();
        zzYcb zzYcb2 = this.zzlg.zzXiN();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzXET zzXET2;
                zzZV9.zzWBj zzWBj2 = zzZV9.zzWBj.zzZ8i(enumeration.nextElement());
                if (this.zzWxk && zzWBj2.hasExtensions() && (zzXET2 = zzWBj2.zzXAK().zzX6s(zzXaN.zzXB7)) != null) {
                    zzYcb2 = zzYcb.zzXI6(zzkp.zzW3U(zzXET2.zzWdQ()).zzWk4()[0].zzZZX());
                }
                if (!zzWBj2.zzZ3I().zzYjW().equals(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzXET2 = zzYcb.zzXI6(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzXET2 = zzZkL.zzVTU(cert.getEncoded()).zzXiN();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return zzYcb2.equals(zzXET2);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        if (other instanceof zzXxM) {
            boolean bl;
            zzXxM zzXxM2 = (zzXxM)other;
            if (this.zzYBr && (bl = zzXxM2.zzYBr) && zzXxM2.zzYWR != this.zzYWR) {
                return false;
            }
            return this.zzlg.equals(zzXxM2.zzlg);
        }
        return super.equals(other);
    }

    @Override
    public final int hashCode() {
        if (!this.zzYBr) {
            this.zzYWR = super.hashCode();
            this.zzYBr = true;
        }
        return this.zzYWR;
    }
}

