/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWm;
import com.aspose.words.internal.zzXFm;
import com.aspose.words.internal.zzXm0;
import com.aspose.words.internal.zzYNb;
import com.aspose.words.internal.zzYry;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.internal.zzZWZ;
import com.aspose.words.zz8;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzX32;
    private zz8 zzWuZ;

    Watermark(Document doc, zz8 watermarkProvider) {
        this.zzX32 = doc;
        this.zzWuZ = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZJ7(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzWBj(text, textWatermarkOptions, this.zzX32);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZP5.zzYxS((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzX32, 75);
        shape.getImageData().setImage(image);
        this.zzWBj(shape, options, this.zzX32);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZP5.zzYxS((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzX32, 75);
        shape.getImageData().setImage(imagePath);
        this.zzWBj(shape, options, this.zzX32);
    }

    public final int getType() {
        Shape shape = this.zzWuZ.get();
        if (shape == null) {
            return 2;
        }
        shape.zzZZ6();
        if (shape.zzWnZ()) {
            return 0;
        }
        if (shape.zzZRB()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzWuZ.add(shape);
    }

    public final void remove() {
        this.zzWuZ.remove();
    }

    private static void zzZJ7(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzYNb.zzYDk(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZP5.zzWBj(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzWBj(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYxS(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzYnw(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYxS(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzYAw() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWCh()) / d2) > (double)(f = pageSetup.zzWIj())) {
            d = (double)f / d3;
        }
        shape.zzXA1(zzXFm.zzZON(d2 * d, 2, zzXm0.zzZEH));
        shape.zzZEk(zzXFm.zzZON(d3 * d, 2, zzXm0.zzZEH));
    }

    private Shape zzWBj(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzWBj(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzYnw(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzWBj(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzWX1() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYry zzYry2 = document.zzZSC().zzZON(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYry2.zzWdO(shape.getTextPath().getText());
        if (textWatermarkOptions.zzWX1()) {
            l = Watermark.zzWBj(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXA1(zzXFm.zzZON(Float.intBitsToFloat(n), 2, zzXm0.zzZEH));
        shape.zzZEk(zzXFm.zzZON(zzWm.zzXUs(l), 2, zzXm0.zzZEH));
    }

    private static long zzWBj(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWCh();
        float f2 = pageSetup.zzWIj();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWm.zzXUs(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWm.zzus(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWm.zzXUs(l) >= Float.intBitsToFloat(n)) {
            return zzWm.zzus(f2 / f3, f2);
        }
        float f6 = f;
        return zzWm.zzus(f6, f6 * f3);
    }

    private static void zzYnw(Shape shape, String string) {
        shape.setName(zzZWZ.zzYxS("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

