/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzW1g;
import com.aspose.words.internal.zzXri;
import com.aspose.words.internal.zzXrr;
import com.aspose.words.internal.zzYNb;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.internal.zzfs;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzDb;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzYab = new HashMap();
    private static HashMap<Integer, Integer> zzXLu = new HashMap();
    private static HashMap<Integer, Integer> zzW7h = new HashMap();
    private static HashMap<Integer, Integer> zzWUl = new HashMap();
    private static HashMap<Integer, Integer> zzW9w = new HashMap();
    private static HashMap<Integer, Integer> zzk2 = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZP5.zzYxS(fileName, "fileName");
        try (zzW1g zzW1g2 = zzZP5.zzWvd(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzYfK(zzW1g2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzYfK(zzfs.zzWBj(stream));
    }

    static FileFormatInfo zzYfK(zzXrr zzXrr2) throws Exception {
        if (zzXrr2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzDb zzDb2 = new zzDb();
            zzXrr zzXrr3 = zzXrr2;
            zzDb zzDb3 = zzDb2;
            return zzDb2.zzYxS(zzXrr3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZON(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzW1Y(zzXri.zzZhX(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzWMZ(zzXri.zzZhX(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYNb.zzY5B(string = zzXri.zzY9Q(FileFormatUtil.zzXzi(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzW1Y(FileFormatUtil.zzX8P(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzWMZ(FileFormatUtil.zzXzi(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXri.zzY9Q(FileFormatUtil.zzX8P(saveFormat));
        if (zzYNb.zzY5B(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzWMZ(zzXri.zzYX1(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXri.zzY9Q(FileFormatUtil.zzWv1(imageType));
    }

    static Exception zzZON(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWrg(int n) {
        return zzXri.toString(FileFormatUtil.zzX8P(n));
    }

    static int zzWMZ(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZP5.zzWBj(zzW9w, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWjI(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZP5.zzWBj(zzk2, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzY7n(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzXzi(int n) {
        return zzZP5.zzWBj(zzYab, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzX8P(int n) {
        return zzZP5.zzWBj(zzXLu, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWv1(int n) {
        return zzZP5.zzWBj(zzW7h, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzW1Y(int n) {
        return zzZP5.zzWBj(zzWUl, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXMF(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZP5.zzYxS(zzW9w, Integer.valueOf(n), Integer.valueOf(n2));
            zzZP5.zzYxS(zzXLu, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWUl.containsKey(n)) {
                zzZP5.zzYxS(zzWUl, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZP5.zzYxS(zzYab, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZP5.zzYxS(zzk2, Integer.valueOf(n), Integer.valueOf(n4));
            zzZP5.zzYxS(zzW7h, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXMF(11, 10, 10, 1);
        FileFormatUtil.zzXMF(11, 0, 0, 1);
        FileFormatUtil.zzXMF(12, 11, 11, 1);
        FileFormatUtil.zzXMF(13, 20, 20, 1);
        FileFormatUtil.zzXMF(13, 0, 254, 1);
        FileFormatUtil.zzXMF(14, 21, 21, 1);
        FileFormatUtil.zzXMF(15, 22, 22, 1);
        FileFormatUtil.zzXMF(16, 23, 23, 1);
        FileFormatUtil.zzXMF(18, 24, 24, 1);
        FileFormatUtil.zzXMF(19, 25, 25, 1);
        FileFormatUtil.zzXMF(20, 26, 26, 1);
        FileFormatUtil.zzXMF(21, 27, 27, 1);
        FileFormatUtil.zzXMF(24, 30, 30, 1);
        FileFormatUtil.zzXMF(17, 31, 31, 1);
        FileFormatUtil.zzXMF(25, 50, 50, 1);
        FileFormatUtil.zzXMF(26, 45, 255, 1);
        FileFormatUtil.zzXMF(27, 51, 51, 1);
        FileFormatUtil.zzXMF(28, 0, 52, 1);
        FileFormatUtil.zzXMF(29, 0, 53, 1);
        FileFormatUtil.zzXMF(31, 0, 54, 1);
        FileFormatUtil.zzXMF(22, 60, 60, 1);
        FileFormatUtil.zzXMF(23, 61, 61, 1);
        FileFormatUtil.zzXMF(34, 40, 64, 1);
        FileFormatUtil.zzXMF(41, 47, 255, 1);
        FileFormatUtil.zzXMF(42, 48, 255, 1);
        FileFormatUtil.zzXMF(35, 41, 255, 1);
        FileFormatUtil.zzXMF(36, 46, 255, 1);
        FileFormatUtil.zzXMF(38, 42, 255, 1);
        FileFormatUtil.zzXMF(37, 44, 255, 1);
        FileFormatUtil.zzXMF(30, 52, 55, 1);
        FileFormatUtil.zzXMF(32, 70, 62, 1);
        FileFormatUtil.zzXMF(33, 73, 63, 1);
        FileFormatUtil.zzXMF(39, 71, 255, 1);
        FileFormatUtil.zzXMF(8, 100, 255, 1);
        FileFormatUtil.zzXMF(9, 105, 255, 1);
        FileFormatUtil.zzXMF(6, 101, 255, 6);
        FileFormatUtil.zzXMF(7, 102, 255, 7);
        FileFormatUtil.zzXMF(5, 104, 255, 5);
        FileFormatUtil.zzXMF(4, 0, 255, 4);
        FileFormatUtil.zzXMF(3, 0, 255, 3);
        FileFormatUtil.zzXMF(40, 72, 255, 1);
        FileFormatUtil.zzXMF(2, 103, 255, 2);
    }
}

