/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzFP;
import com.aspose.words.internal.zzW1g;
import com.aspose.words.internal.zzWPR;
import com.aspose.words.internal.zzWXl;
import com.aspose.words.internal.zzX0z;
import com.aspose.words.internal.zzXCE;
import com.aspose.words.internal.zzXLE;
import com.aspose.words.internal.zzXrr;
import com.aspose.words.internal.zzYwE;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.internal.zzZPb;
import com.aspose.words.internal.zzZWZ;
import com.aspose.words.zzDb;
import com.aspose.words.zzVTk;
import com.aspose.words.zzWzI;
import com.aspose.words.zzXxU;
import com.aspose.words.zzYSv;
import com.aspose.words.zzYW7;
import com.aspose.words.zzYk2;
import com.aspose.words.zzZD0;
import com.aspose.words.zzZJP;
import com.aspose.words.zzal;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzWBj(zzXrr zzXrr2, zzXrr zzXrr3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZP5.zzYxS((Object)zzXrr2, "srcStream");
        zzZP5.zzYxS((Object)zzXrr3, "dstStream");
        zzZP5.zzYxS((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYxS(zzXrr2, zzXrr3, certificateHolder, signOptions);
        zzXrr3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzWBj(zzXrr.zzYxS(srcStream), (zzXrr)zzXrr.zzZON(dstStream), certHolder, signOptions);
    }

    private static void zzYxS(zzXrr zzXrr2, zzXrr zzXrr3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZON(digitalSignature);
        }
        if (zzDb.zzW80(zzXrr2)) {
            DigitalSignatureUtil.zzWBj(zzXrr2, zzXrr3, digitalSignature, true);
            return;
        }
        zzDb zzDb2 = new zzDb();
        zzXrr zzXrr4 = zzXrr2;
        zzDb zzDb3 = zzDb2;
        FileFormatInfo fileFormatInfo = zzDb2.zzYxS(zzXrr4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzX0z zzX0z2 = new zzX0z(zzXrr2);
                int n = fileFormatInfo.zzXDG() == 1 ? 1 : 2;
                zzVTk.zzWBj(zzX0z2, digitalSignature, n);
                zzXrr3.zzXMi(0L);
                zzX0z2.zzZon(zzXrr3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzWBj(fileFormatInfo.zzZRU(), zzXrr3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzWBj(zzXrr2, zzXrr3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzWBj(zzXrr2, zzXrr3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZP5.zzYxS(srcFileName, "srcFileName");
        zzZP5.zzYxS(dstFileName, "dstFileName");
        try (zzW1g zzW1g2 = zzZP5.zzYxS(srcFileName, 3, 1);){
            try (zzW1g zzW1g3 = zzZP5.zzYxS(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWBj((zzXrr)zzW1g2, (zzXrr)zzW1g3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYwE zzYwE2 = zzXrr.zzZON(dstStream);
        zzXrr zzXrr2 = zzXrr.zzYxS(srcStream);
        DigitalSignatureUtil.zzWBj(zzXrr2, (zzXrr)zzYwE2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzW1g zzW1g2 = zzZP5.zzYxS(srcFileName, 3, 1);){
            try (zzW1g zzW1g3 = zzZP5.zzYxS(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZdS(zzW1g2, zzW1g3);
            }
            return;
        }
    }

    private static void zzZdS(zzXrr zzXrr2, zzXrr zzXrr3) throws Exception {
        zzDb zzDb2 = new zzDb();
        zzXrr zzXrr4 = zzXrr2;
        zzDb zzDb3 = zzDb2;
        FileFormatInfo fileFormatInfo = zzDb2.zzYxS(zzXrr4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzX0z zzX0z2 = new zzX0z(zzXrr2);
                zzX0z2.zzZrx().zzYCR("_xmlsignatures");
                zzX0z2.zzZrx().zzYCR("_signatures");
                zzXrr3.zzXcX(0L);
                zzX0z2.zzZon(zzXrr3);
                zzXrr zzXrr5 = zzXrr3;
                zzXrr5.zzXMi(zzXrr5.zzZjF());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWPR zzWPR2 = new zzWPR(zzXrr2);
                zzXCE zzXCE2 = zzWPR2.zzWBj(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXCE2 != null) {
                    for (zzWXl zzWXl2 : zzXCE2.zzZUW()) {
                        String string = zzXCE2.zzWBj(zzWXl2);
                        zzWPR2.zzXHB().remove(string);
                    }
                    zzWPR2.zzXHB().remove(zzXCE2.getName());
                    zzWXl zzWXl3 = zzWPR2.zzZUW().zzXC3("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWPR2.zzZUW().remove(zzWXl3.getId());
                    zzWPR2.zzYv1();
                }
                zzXrr3.zzXcX(0L);
                zzWPR2.zzZon(zzXrr3);
                zzXrr zzXrr6 = zzXrr3;
                zzXrr6.zzXMi(zzXrr6.zzZjF());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzZdS(zzXrr.zzYxS(srcStream), zzXrr.zzZON(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzW1g zzW1g2 = zzZP5.zzYxS(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYrk(zzW1g2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYrk(zzXrr zzXrr2) throws Exception {
        if (zzDb.zzW80(zzXrr2)) {
            return DigitalSignatureUtil.zzZgN(zzXrr2);
        }
        zzDb zzDb2 = new zzDb();
        zzXrr zzXrr3 = zzXrr2;
        zzDb zzDb3 = zzDb2;
        FileFormatInfo fileFormatInfo = zzDb2.zzYxS(zzXrr3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXrr2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYrk(zzXrr.zzYxS(stream));
    }

    static zzXLE zzWBj(zzX0z zzX0z2, String string) throws Exception {
        zzWzI zzWzI2 = new zzWzI(zzX0z2);
        if (zzWzI2.zzYKU()) {
            zzXLE zzXLE2 = zzWzI2.zzWzI(string);
            return zzXLE2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZJC(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZWZ.zzYxS("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWOD(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZJC(n);
    }

    private static void zzWBj(zzXrr zzXrr2, zzXrr zzXrr3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWPR zzWPR2 = new zzWPR(zzXrr2);
        zzZJP zzZJP2 = bl ? new zzZD0(zzWPR2) : new zzXxU(zzWPR2);
        zzZJP2.zzYxS(digitalSignature);
        zzXrr3.zzXMi(0L);
        zzWPR2.zzZon(zzXrr3);
    }

    private static void zzWBj(zzXrr zzXrr2, zzXrr zzXrr3, DigitalSignature digitalSignature) throws Exception {
        zzYW7 zzYW72 = new zzYW7(zzXrr2);
        zzYk2 zzYk22 = new zzYk2(zzYW72);
        zzYk22.zzYxS(digitalSignature);
        zzXrr3.zzXMi(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXrr zzXrr4 = zzXrr3;
        zzYW7 zzYW73 = zzYW72;
        zzYW73.zzWBj(zzXrr4, string, null);
    }

    private static void zzWBj(zzX0z zzX0z2, zzXrr zzXrr2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXLE zzXLE2 = DigitalSignatureUtil.zzWBj(zzX0z2, string);
        zzXLE zzXLE3 = new zzXLE();
        DigitalSignatureUtil.zzWBj((zzXrr)zzXLE2, (zzXrr)zzXLE3, digitalSignature, false);
        zzX0z zzX0z3 = zzWzI.zzZON(zzXLE3, string);
        zzX0z3.zzZon(zzXrr2);
    }

    private static DigitalSignatureCollection zzZgN(zzXrr zzXrr2) throws Exception {
        zzXrr2.zzXcX(0L);
        zzWPR zzWPR2 = new zzWPR(zzXrr2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXCE zzXCE2 = zzWPR2.zzWBj(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXCE2 != null) {
            for (zzWXl zzWXl2 : zzXCE2.zzZUW()) {
                String string = zzXCE2.zzWBj(zzWXl2);
                zzXCE zzXCE3 = zzWPR2.zzWkR(string);
                zzXCE zzXCE4 = zzWPR2.zzWBj(zzXCE3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzFP zzFP2 = zzZPb.zzus(zzXCE4.zzW1Z().zzVT3());
                zzal.zzWBj(zzXCE3.zzZz(), zzFP2, new zzYSv(zzWPR2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

