/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzYwz;
import com.aspose.words.internal.zzZP5;
import com.aspose.words.zzOd;
import com.aspose.words.zzW4v;
import com.aspose.words.zzWJe;
import com.aspose.words.zzWTu;
import com.aspose.words.zzX7a;
import com.aspose.words.zzXn8;
import com.aspose.words.zzY1k;
import com.aspose.words.zzZNq;
import com.aspose.words.zzZgh;
import com.aspose.words.zzZiK;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZgh zzZ4y;

    ChartSeriesCollection(zzZgh dmlChart) {
        this.zzZ4y = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZ4y.zzVT5().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZ4y.zzVT5().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZ4y.zzVT5().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZ4y.zzVT5().clear();
        this.zzX5y(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWBj(seriesName, values);
        chartSeries.zzWUe().zzZdS(ChartSeriesCollection.zzZnb(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWBj(seriesName, yValues);
        chartSeries.zzWUe().zzZdS(ChartSeriesCollection.zzZdS(xValues));
        return chartSeries;
    }

    private ChartSeries zzWBj(String string, zzYwz[] zzYwzArray, double[] dArray) {
        if (zzYwzArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYwzArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYwzArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWBj(string, dArray);
        chartSeries.zzWUe().zzZdS(ChartSeriesCollection.zzWBj(zzYwzArray));
        if (!this.zzZ4y.zzYbU()) {
            this.zzX5y(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzWBj(seriesName, zzYwz.zzWBj(dates), values);
    }

    private void zzX5y(boolean bl) {
        zzOd zzOd2 = zzZP5.zzWBj((Object)this.zzZ4y, zzOd.class);
        if (zzOd2 != null && zzOd2.zzWlE().zzZza()) {
            zzOd2.zzWlE().zzY1Z().zzZnb(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZ4y.zzYPR() != 15) {
            this.zzZ4y.zzYhT(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzWBj(seriesName, yValues);
        chartSeries.zzWK3().zzWt7().zzZnb(3, this.zzZ4y.zzYW0());
        chartSeries.zzWUe().zzZdS(ChartSeriesCollection.zzZdS(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzZJt().zzZdS(ChartSeriesCollection.zzZdS(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzWBj(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZ4y);
        chartSeries.setName(string);
        this.zzXtm(chartSeries);
        chartSeries.zzYLP(this.zzZ4y.zzYAV().zzYEw() + 1);
        chartSeries.zzXdg(this.zzZ4y.zzYAV().zzXMz() + 1);
        chartSeries.zzWEF().zzZdS(ChartSeriesCollection.zzZdS(dArray));
        this.zzZ4y.zzXCA().zzXVC();
        this.zzZ4y.zzVT5().zzXhz(chartSeries);
        return chartSeries;
    }

    private void zzXtm(ChartSeries chartSeries) {
        chartSeries.zzWK3().zzWt7().zzZnb(5, new zzY1k());
        switch (this.zzZ4y.zzYPR()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzWBj(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzWBj(chartSeries, 5);
                ChartSeriesCollection.zzXMF(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzWBj(chartSeries, 1);
                ChartSeriesCollection.zzXMF(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZEp(chartSeries);
            }
        }
    }

    private static void zzZEp(ChartSeries chartSeries) {
        zzY1k zzY1k2 = new zzY1k();
        zzY1k2.setOutline(new zzX7a());
        zzZNq zzZNq2 = new zzZNq();
        zzZNq2.zzYE(1);
        zzY1k2.getOutline().setFill(new zzZiK(zzZNq2));
        zzY1k2.getOutline().zzYzJ(19050.0);
        chartSeries.zzWK3().zzWt7().zzZnb(5, zzY1k2);
    }

    private static void zzXMF(ChartSeries chartSeries) {
        zzY1k zzY1k2 = new zzY1k();
        zzY1k2.setOutline(new zzX7a());
        zzY1k2.getOutline().setFill(new zzWJe());
        zzY1k2.getOutline().setEndCap(0);
        zzY1k2.getOutline().zzYzJ(19050.0);
        chartSeries.zzWK3().zzWt7().zzZnb(5, zzY1k2);
    }

    private static void zzWBj(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzYoT());
        chartMarker.zzXWL().zzZnb(0, n);
        chartSeries.zzWK3().zzWt7().zzZnb(4, chartMarker);
    }

    private static zzWTu zzZdS(double[] dArray) {
        int n = 0;
        zzWTu zzWTu2 = new zzWTu(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzWTu2.zzX6s(new zzXn8(n, d, "General"));
            }
            ++n;
        }
        zzWTu2.zzWy7(dArray.length);
        return zzWTu2;
    }

    private static zzWTu zzWBj(zzYwz[] zzYwzArray) {
        int n = 0;
        zzWTu zzWTu2 = new zzWTu(2);
        zzYwz[] zzYwzArray2 = zzYwzArray;
        int n2 = zzYwzArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYwz zzYwz2 = zzYwzArray2[i];
            zzWTu2.zzX6s(new zzXn8(n++, zzYwz2.zzW1k(), "m/d/yyyy"));
        }
        zzWTu2.zzWy7(zzYwzArray.length);
        return zzWTu2;
    }

    private static zzWTu zzZnb(String[] stringArray) {
        int n = 0;
        zzWTu zzWTu2 = new zzWTu(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzWTu2.zzX6s(new zzW4v(n++, string));
        }
        zzWTu2.zzWy7(stringArray.length);
        return zzWTu2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZ4y.zzVT5().getCount();
    }
}

