/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXFa;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYyQ = new ArrayList();
    private final Map<String, DataColumn> zzZTO = new HashMap<String, DataColumn>();
    private DataTable zzZ4s;

    DataColumnCollection(DataTable table) {
        this.zzZ4s = table;
    }

    public void add(DataColumn column) {
        if (zzXFa.zzYBK(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzXts(column.getColumnName());
        if (this.zzZTO.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzuE(this.zzZ4s);
        column.setOrdinal(this.zzYyQ.size());
        this.zzYyQ.add(column);
        this.zzZTO.put(string, column);
        this.zzZ4s.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZ4s);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZ4s);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXFa.zzYBK(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzXts(columnName);
        DataColumn dataColumn = this.zzZTO.get(string);
        if (dataColumn != null) {
            int n = this.zzYyQ.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYyQ.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYyQ.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYyQ.remove(n);
            this.zzZTO.remove(DataColumnCollection.zzXts(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZ4s.getRows()) {
                dataRow.remove(n);
            }
            this.zzZ4s.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYyQ.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYyQ.iterator();
    }

    public void clear() {
        this.zzZTO.clear();
        this.zzYyQ.clear();
    }

    final DataColumn[] zzXvC() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYyQ);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXWJ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYyQ.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYyQ.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzXts(string);
            String string3 = DataColumnCollection.zzXts(dataColumn.getColumnName());
            this.zzZTO.remove(string3);
            this.zzZTO.put(string2, dataColumn);
            return;
        }
    }

    private static String zzXts(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

