/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzXFa;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.zzXSw;
import com.aspose.words.zzXlJ;
import com.aspose.words.zzZJV;

public final class Section
extends CompositeNode<Node>
implements zzZJV {
    private zzXlJ zzZlX;
    private PageSetup zzWqK;
    private HeaderFooterCollection zzh1;

    public Section(DocumentBase doc) {
        this(doc, new zzXlJ());
    }

    Section(DocumentBase doc, zzXlJ sectPr) {
        super(doc);
        this.zzZlX = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzh1 == null) {
            this.zzh1 = new HeaderFooterCollection(this);
        }
        return this.zzh1;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWqK == null) {
            Section section = this;
            this.zzWqK = new PageSetup(section, section.getDocument().zzXRK(), this.getDocument().getStyles(), new zzXWJ(this));
        }
        return this.zzWqK;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZDj();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzeH(!value);
    }

    final zzXlJ zzJ0() {
        return this.zzZlX;
    }

    final void zzYUy(zzXlJ zzXlJ2) {
        this.zzZlX = zzXlJ2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXWJ(boolean bl, zzXSw zzXSw2) {
        zzXlJ zzXlJ2;
        Section section = (Section)super.zzXWJ(bl, zzXSw2);
        zzXlJ zzXlJ3 = this.zzZlX;
        section.zzZlX = zzXlJ2 = (zzXlJ)zzXlJ3.zzQN();
        section.zzWqK = null;
        section.zzh1 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXWJ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzVOH(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzuE(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzuE(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzZzh(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzYGR(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzZzh(n) == null;
            }
        }
        return false;
    }

    final void zzYUy(Shape shape, boolean bl) throws Exception {
        this.zzXWJ(shape, 4, bl);
        this.zzXWJ(shape, 0, bl);
        this.zzXWJ(shape, 1, bl);
    }

    private void zzXWJ(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzhv());
        shape2.setName(zzXFa.zzVOH("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzYfI() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzX9T()) {
                if (!shape.zzWFs()) continue;
                shape.remove();
            }
        }
    }

    private void zzuE(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzVOH(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzZlX.zz8O(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXRK().zzWm9.zzZLj(key);
        }
        return zzXlJ.zzXTK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzZlX.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXRK().zzWm9.zzZcl(key, value);
            return;
        }
        this.zzZlX.zzZcl(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzZlX.clear();
    }

    final boolean zzYnA() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXwF() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzXWJ
    implements zzZJV {
        private Section zzYZJ;

        zzXWJ(Section section) {
            this.zzYZJ = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYoP().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYoP().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYoP().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZJV zzYoP() {
            Document document = zzYFS.zzXWJ((Object)this.zzYZJ.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYZJ;
        }
    }
}

