/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXNx;
import com.aspose.words.internal.zzZno;

public abstract class SaveOptions {
    private boolean zzZLP;
    private IDocumentSavingCallback zzYf5;
    private boolean zzZKf = true;
    private boolean zzXsH = false;
    private boolean zzYFy = true;
    private boolean zzWpD;
    private String zzZs0;
    private boolean zzMW;
    private boolean zzWGC = false;
    private boolean zzZTz = true;
    private int zzZ7h = 1;
    private int zzZxD = 1;
    private int zzRq = 0;
    private String zzX7N = "";
    private boolean zzXCo = true;
    private boolean zzZX5 = true;
    private boolean zzYyf;
    private boolean zzZ7m;
    private int zzY6R = 0;
    private boolean zzNo = true;
    private boolean zzXlO = false;
    private boolean zzYYC = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzVPg() {
        return false;
    }

    boolean zzW1y() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYFy;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYFy = value;
    }

    public String getTempFolder() {
        return this.zzZs0;
    }

    public void setTempFolder(String value) {
        this.zzZs0 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWpD;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWpD = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzMW;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzMW = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWGC;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWGC = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzZTz;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzZTz = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZ7h;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZ7h = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzRq;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzRq = value;
    }

    public int getImlRenderingMode() {
        return this.zzZxD;
    }

    public void setImlRenderingMode(int value) {
        this.zzZxD = value;
    }

    public String getDefaultTemplate() {
        return this.zzX7N;
    }

    public void setDefaultTemplate(String value) {
        this.zzX7N = value;
    }

    public boolean getUpdateFields() {
        return this.zzXCo;
    }

    public void setUpdateFields(boolean value) {
        this.zzXCo = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYyf;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYyf = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZ7m;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZ7m = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzXlO;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzXlO = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXsH;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXsH = value;
    }

    final boolean zzZLH() {
        return this.zzZX5;
    }

    final boolean zzYCf() {
        return this.zzNo;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzW4v(zzZno.zzYar(zzXNx.zzY2V(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzY6R;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzY6R = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYf5;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYf5 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZLP;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZLP = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzYYC;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzYYC = value;
    }

    final boolean zzXk3() {
        return this.zzZKf;
    }
}

