/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.zzWGV;
import com.aspose.words.zzWqD;
import com.aspose.words.zzWyq;
import com.aspose.words.zzXSw;
import com.aspose.words.zzXsz;
import com.aspose.words.zzYh8;
import com.aspose.words.zzZF2;
import com.aspose.words.zzZi;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZF2,
Iterable<T> {
    private Node zzYUC;
    private Node zzYqt;
    private Node zzfy;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzVOH((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzdq() {
        return this.zzYJV() != null;
    }

    final boolean zzXTx() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYdj() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzWyq) {
                return true;
            }
            CompositeNode compositeNode = zzYFS.zzXWJ((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYdj()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzYUC;
    }

    public Node getLastChild() {
        return this.zzYqt;
    }

    final Node zzYJV() {
        return zzWqD.zzZdt(this.getFirstChild(), false);
    }

    final Node zz7a() {
        return zzWqD.zzWVH(this.getLastChild(), false);
    }

    final CompositeNode zzZp7() {
        return (CompositeNode)zzWqD.zzZdt(this.getFirstChild(), true);
    }

    final CompositeNode zzZoP() {
        return (CompositeNode)zzWqD.zzWVH(this.getLastChild(), true);
    }

    final Node zzZ4l() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzWqD.zzZiq((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZ4M() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzWqD.zzZiq((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXWJ(boolean bl, zzXSw zzXSw2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXWJ(bl, zzXSw2);
        ((CompositeNode)super.zzXWJ(bl, zzXSw2)).zzYqt = null;
        compositeNode.zzYUC = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzVRg(node.zzXWJ(true, zzXSw2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZjo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZjo(StringBuilder stringBuilder) {
        this.zzXYg(stringBuilder);
        zzYFS.zzVOH(stringBuilder, this.zzqo());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzVOH(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzWqD.zzWKM(nodeType);
            Node node2 = node = bl ? this.zzYJV() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzWkR() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZi.zzYUy(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZi.zzuE(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzYh8(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXWJ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXWJ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzVOH(oldChild, false);
    }

    private Node zzVOH(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXWJ(node, (Node)this, null, 1);
        if (documentBase.zzX0X() && zzWqD.zzXpI(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXWJ(nodeChangingArgs);
        }
        if (!bl && zzWqD.zzY7s(node)) {
            zzWqD.zzZcl(node, false);
        }
        Node node2 = this.zzWZH(node);
        if (nodeChangingArgs != null) {
            documentBase.zzVOH(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzXsz.zzZSh(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzVRg(Node node) {
        node.getParentNode();
        if (this.zzYqt == null) {
            node.zzXcW(null);
            node.zzdR(null);
            this.zzYUC = node;
        } else {
            node.zzXcW(this.zzYqt);
            node.zzdR(null);
            this.zzYqt.zzdR(node);
        }
        this.zzYqt = node;
        node.zzYhH(this);
        return node;
    }

    final void zzXWJ(Node node, Node node2, Node node3) {
        this.zzXWJ(node, node2, node3, false);
    }

    final void zzXWJ(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzYGR(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzVOH(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYUy(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzWqD.zzZiq(node3.getNodeType())) continue;
            if (zzWqD.zzqi(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzqo().length();
    }

    String zzqo() {
        return "";
    }

    final String zzZGe() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXYg(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzXYg(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZjo(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXWJ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzVOH(visitor));
    }

    abstract int zzXWJ(DocumentVisitor var1) throws Exception;

    abstract int zzVOH(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzYGR(Node var1);

    final Node zzXWJ(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzXv3(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzYGR(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzWGV(documentBase);
            try {
                compositeNode.zzVOH(node, true);
            }
            finally {
                ((zzWGV)object).dispose();
            }
        }
        if ((object = documentBase.zzXWJ(node, null, (Node)this, 0)) != null) {
            documentBase.zzXWJ((NodeChangingArgs)object);
        }
        if (this.zzYqt == null) {
            node.zzXcW(null);
            node.zzdR(null);
            this.zzYUC = node;
            this.zzYqt = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzVOH(node, node2);
            } else {
                this.zzYUy(node, this.zzYUC);
            }
        } else if (node2 != null) {
            this.zzYUy(node, node2);
        } else {
            this.zzVOH(node, this.zzYqt);
        }
        node.zzYhH(this);
        if (object != null) {
            documentBase.zzVOH((NodeChangingArgs)object);
        }
        if (documentBase.zzX0X()) {
            zzWqD.zzXWJ(node, compositeNode, node3);
        }
        return node;
    }

    private void zzVOH(Node node, Node node2) {
        Node node3 = node2.zzZqb();
        node.zzXcW(node2);
        node.zzdR(node3);
        node2.zzdR(node);
        if (node3 == null) {
            this.zzYqt = node;
            return;
        }
        node3.zzXcW(node);
    }

    private void zzYUy(Node node, Node node2) {
        Node node3 = node2.zzF4();
        node.zzXcW(node3);
        node.zzdR(node2);
        node2.zzXcW(node);
        if (node3 == null) {
            this.zzYUC = node;
            return;
        }
        node3.zzdR(node);
    }

    private Node zzWZH(Node node) {
        if (node == this.zzYUC) {
            if (this.zzYUC == this.zzYqt) {
                this.zzYUC = null;
                this.zzYqt = null;
            } else {
                this.zzYUC = node.zzZqb();
                this.zzYUC.zzXcW(null);
            }
        } else {
            Node node2 = node.zzF4();
            Node node3 = node.zzZqb();
            node2.zzdR(node3);
            if (node3 == null) {
                this.zzYqt = node2;
            } else {
                node3.zzXcW(node2);
            }
        }
        node.zzdR(null);
        node.zzXcW(null);
        node.zzYhH(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzfy = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzfy;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

