/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzW1g;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzY1o = new ArrayList();
    private final Map<String, DataColumn> zzui = new HashMap<String, DataColumn>();
    private DataTable zzWXt;

    DataColumnCollection(DataTable table) {
        this.zzWXt = table;
    }

    public void add(DataColumn column) {
        if (zzW1g.zzZJs(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzWUa(column.getColumnName());
        if (this.zzui.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzAY(this.zzWXt);
        column.setOrdinal(this.zzY1o.size());
        this.zzY1o.add(column);
        this.zzui.put(string, column);
        this.zzWXt.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWXt);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWXt);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzW1g.zzZJs(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzWUa(columnName);
        DataColumn dataColumn = this.zzui.get(string);
        if (dataColumn != null) {
            int n = this.zzY1o.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzY1o.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzY1o.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzY1o.remove(n);
            this.zzui.remove(DataColumnCollection.zzWUa(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzWXt.getRows()) {
                dataRow.remove(n);
            }
            this.zzWXt.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzY1o.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzY1o.iterator();
    }

    public void clear() {
        this.zzui.clear();
        this.zzY1o.clear();
    }

    final DataColumn[] zzYTL() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzY1o);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzYn3(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzY1o.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzY1o.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzWUa(string);
            String string3 = DataColumnCollection.zzWUa(dataColumn.getColumnName());
            this.zzui.remove(string3);
            this.zzui.put(string2, dataColumn);
            return;
        }
    }

    private static String zzWUa(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

