/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzBS;
import com.aspose.words.internal.zzWXh;
import com.aspose.words.internal.zzXRU;
import com.aspose.words.internal.zzYCC;
import com.aspose.words.internal.zzYis;
import com.aspose.words.internal.zzZAQ;
import com.aspose.words.internal.zzZCs;
import com.aspose.words.internal.zzZRU;
import com.aspose.words.internal.zzda;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzYqQ
extends CertPathBuilderSpi {
    private final zzWXh zzXm0;
    private zzYis zzYWL;

    zzYqQ(zzWXh zzWXh2) {
        this.zzXm0 = zzWXh2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzda pkixParams;
        if (params instanceof zzda) {
            pkixParams = (zzda)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzda.zzYn3((PKIXBuilderParameters)params).zzWdC();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzda.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzXRU zzXRU2 = pkixParams.zzXP3().zzYrH();
        try {
            collection = zzBS.zzYn3(zzXRU2, pkixParams.zzXP3().zzXNV());
            collection.addAll(zzBS.zzYn3(zzXRU2, pkixParams.zzXP3().zzXLw()));
        }
        catch (zzYis zzYis2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYis2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYn3(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzYWL != null) {
            throw new CertPathBuilderException(this.zzYWL.getMessage(), this.zzYWL.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYn3(X509Certificate x509Certificate, zzda zzda2, List list) throws CertPathBuilderException {
        zzYCC zzYCC2;
        zzZCs zzZCs2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzda2.zzXlq().contains(x509Certificate)) {
            return null;
        }
        if (zzda2.zzNO() != -1 && list.size() - 1 > zzda2.zzNO()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZCs2 = new zzZCs(this.zzXm0);
            zzYCC2 = new zzYCC(this.zzXm0);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzBS.zzYn3(x509Certificate, zzda2.zzXP3().zzWtZ(), zzda2.zzXP3().zzW38()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZCs2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYis("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzYCC2.engineValidate(certPath, zzda2);
                }
                catch (Exception exception) {
                    throw new zzYis("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZAQ> arrayList = new ArrayList<zzZAQ>();
            arrayList.addAll(zzda2.zzXP3().zzXNV());
            try {
                arrayList.addAll(zzBS.zzYn3(x509Certificate.getExtensionValue(zzZRU.zzVX9.getId()), zzda2.zzXP3().zzXnX()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYis("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzBS.zzYn3(x509Certificate, zzda2.zzXP3().zzXLw(), arrayList));
            }
            catch (zzYis zzYis2) {
                throw new zzYis("Cannot find issuer certificate for certificate in certification path.", zzYis2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYis("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYn3(x509Certificate2, zzda2, list);
            }
        }
        catch (zzYis zzYis3) {
            this.zzYWL = zzYis3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

