/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzW1g;
import com.aspose.words.internal.zzW7n;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.internal.zzWbL;
import com.aspose.words.internal.zzYOz;
import com.aspose.words.internal.zzZ1S;
import com.aspose.words.internal.zzdO;
import com.aspose.words.zzYSm;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzxH;
    private zzYSm zzW0t;

    Watermark(Document doc, zzYSm watermarkProvider) {
        this.zzxH = doc;
        this.zzW0t = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzsS(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYn3(text, textWatermarkOptions, this.zzxH);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWAB.zzWOc((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzxH, 75);
        shape.getImageData().setImage(image);
        this.zzYn3(shape, options, this.zzxH);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWAB.zzWOc((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzxH, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYn3(shape, options, this.zzxH);
    }

    public final int getType() {
        Shape shape = this.zzW0t.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYTb();
        if (shape.zzWSS()) {
            return 0;
        }
        if (shape.zzZQE()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzW0t.add(shape);
    }

    public final void remove() {
        this.zzW0t.remove();
    }

    private static void zzsS(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzZ1S.zzZMD(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWAB.zzYn3(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYn3(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzWOc(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWfA(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzWOc(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzVRA() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzZic()) / d2) > (double)(f = pageSetup.zzYd8())) {
            d = (double)f / d3;
        }
        shape.zzXq3(zzWbL.zzXlm(d2 * d, 2, zzW7n.zzYXU));
        shape.zzZde(zzWbL.zzXlm(d3 * d, 2, zzW7n.zzYXU));
    }

    private Shape zzYn3(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYn3(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWfA(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYn3(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzf6() ? 1.0f : textWatermarkOptions.getFontSize();
        zzdO zzdO2 = document.zzYEt().zzXlm(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzdO2.zzib(shape.getTextPath().getText());
        if (textWatermarkOptions.zzf6()) {
            l = Watermark.zzYn3(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXq3(zzWbL.zzXlm(Float.intBitsToFloat(n), 2, zzW7n.zzYXU));
        shape.zzZde(zzWbL.zzXlm(zzYOz.zzYte(l), 2, zzW7n.zzYXU));
    }

    private static long zzYn3(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzZic();
        float f2 = pageSetup.zzYd8();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYOz.zzYte(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYOz.zzWUa(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYOz.zzYte(l) >= Float.intBitsToFloat(n)) {
            return zzYOz.zzWUa(f2 / f3, f2);
        }
        float f6 = f;
        return zzYOz.zzWUa(f6, f6 * f3);
    }

    private static void zzWfA(Shape shape, String string) {
        shape.setName(zzW1g.zzWOc("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

