/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzW1g;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.zzZ5L;
import com.aspose.words.zzZ9l;
import com.aspose.words.zzZoq;

public final class Section
extends CompositeNode<Node>
implements zzZ5L {
    private zzZ9l zzXrK;
    private PageSetup zzZWT;
    private HeaderFooterCollection zzYiP;

    public Section(DocumentBase doc) {
        this(doc, new zzZ9l());
    }

    Section(DocumentBase doc, zzZ9l sectPr) {
        super(doc);
        this.zzXrK = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYiP == null) {
            this.zzYiP = new HeaderFooterCollection(this);
        }
        return this.zzYiP;
    }

    public final PageSetup getPageSetup() {
        if (this.zzZWT == null) {
            Section section = this;
            this.zzZWT = new PageSetup(section, section.getDocument().zzZwP(), this.getDocument().getStyles(), new zzYn3(this));
        }
        return this.zzZWT;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzY3f();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzXIK(!value);
    }

    final zzZ9l zzWz3() {
        return this.zzXrK;
    }

    final void zzXlm(zzZ9l zzZ9l2) {
        this.zzXrK = zzZ9l2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYn3(boolean bl, zzZoq zzZoq2) {
        zzZ9l zzZ9l2;
        Section section = (Section)super.zzYn3(bl, zzZoq2);
        zzZ9l zzZ9l3 = this.zzXrK;
        section.zzXrK = zzZ9l2 = (zzZ9l)zzZ9l3.zzXCD();
        section.zzZWT = null;
        section.zzYiP = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYn3(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzWOc(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzAY(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzAY(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWCL(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWD0(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWCL(n) == null;
            }
        }
        return false;
    }

    final void zzXlm(Shape shape, boolean bl) throws Exception {
        this.zzYn3(shape, 4, bl);
        this.zzYn3(shape, 0, bl);
        this.zzYn3(shape, 1, bl);
    }

    private void zzYn3(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzZkI());
        shape2.setName(zzW1g.zzWOc("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzZYo() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZGQ()) {
                if (!shape.zzYTb()) continue;
                shape.remove();
            }
        }
    }

    private void zzAY(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzWOc(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXrK.zzYr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZwP().zzZTS.zzXoa(key);
        }
        return zzZ9l.zzWNe(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXrK.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZwP().zzZTS.zzO6(key, value);
            return;
        }
        this.zzXrK.zzO6(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXrK.clear();
    }

    final boolean zzXCO() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzWo7() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzYn3
    implements zzZ5L {
        private Section zzpo;

        zzYn3(Section section) {
            this.zzpo = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZ13().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZ13().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZ13().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZ5L zzZ13() {
            Document document = zzWAB.zzYn3((Object)this.zzpo.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzpo;
        }
    }
}

