/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWFy;
import com.aspose.words.internal.zzXOD;

public abstract class SaveOptions {
    private boolean zzWfy;
    private IDocumentSavingCallback zzYNI;
    private boolean zzWMx = true;
    private boolean zzRH = false;
    private boolean zzYXM = true;
    private boolean zzZn3;
    private String zzW0U;
    private boolean zzZ92;
    private boolean zzZdz = false;
    private boolean zzXnH = true;
    private int zzX5M = 1;
    private int zzVYY = 1;
    private int zzW4s = 0;
    private String zzXEs = "";
    private boolean zzom = true;
    private boolean zzE1 = true;
    private boolean zzX8i;
    private boolean zzZm8;
    private int zzWLP = 0;
    private boolean zzX7N = true;
    private boolean zzlh = false;
    private boolean zzWHF = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzXWn() {
        return false;
    }

    boolean zzZCL() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYXM;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYXM = value;
    }

    public String getTempFolder() {
        return this.zzW0U;
    }

    public void setTempFolder(String value) {
        this.zzW0U = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZn3;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZn3 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZ92;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZ92 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZdz;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZdz = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzXnH;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzXnH = value;
    }

    public int getDmlRenderingMode() {
        return this.zzX5M;
    }

    public void setDmlRenderingMode(int value) {
        this.zzX5M = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzW4s;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzW4s = value;
    }

    public int getImlRenderingMode() {
        return this.zzVYY;
    }

    public void setImlRenderingMode(int value) {
        this.zzVYY = value;
    }

    public String getDefaultTemplate() {
        return this.zzXEs;
    }

    public void setDefaultTemplate(String value) {
        this.zzXEs = value;
    }

    public boolean getUpdateFields() {
        return this.zzom;
    }

    public void setUpdateFields(boolean value) {
        this.zzom = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzX8i;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzX8i = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZm8;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZm8 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzlh;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzlh = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzRH;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzRH = value;
    }

    final boolean zzZIU() {
        return this.zzE1;
    }

    final boolean zzW2f() {
        return this.zzX7N;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzTR(zzXOD.zzYKv(zzWFy.zzX6Y(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWLP;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWLP = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYNI;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYNI = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWfy;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWfy = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzWHF;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzWHF = value;
    }

    final boolean zzYzl() {
        return this.zzWMx;
    }
}

