/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZdC;
import com.aspose.words.zzLD;
import com.aspose.words.zzWti;
import com.aspose.words.zzWx3;
import com.aspose.words.zzZcM;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWti,
Iterable<T> {
    private Node zzZB9;
    private CompositeNode zzWva;
    private DocumentBase zzX3u;
    private boolean zzWYv;
    private int zzZ23;
    private int zzYkD;
    private Node zzOp;
    private int zzXfG;
    private zzWx3 zzA3;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzZcM.zzWB7(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZcM(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWx3 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzWva = container;
        this.zzX3u = container.getDocument();
        this.zzA3 = matcher;
        this.zzWYv = isDeep;
        this.zzcS();
    }

    public Node get(int index) {
        try {
            this.zzX0f();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYkD == index) {
                return this.zzOp;
            }
            int n = index - this.zzYkD;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzWFJ(nodeCollection.zzOp, n);
            if (node != null) {
                this.zzYkD = index;
                this.zzOp = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWYv) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWva.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWYv) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWva.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzLa();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzLD(this);
    }

    final <TNode extends Node> zzLD<TNode> zzV7() {
        return new zzLD(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzLa() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZdC.zzYn3(arrayList, node);
        }
        return arrayList;
    }

    private Node zzWFJ(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZ85(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZ76(curNode, true);
    }

    private Node zzZ76(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzZB9 = node;
        do {
            node2 = this.zzZB9;
            Node node3 = this.zzWYv ? this.zzYn3(true, this.zzZB9) : (this.zzZB9 = this.zzA3.zzR5() ? this.zzXlm(true, this.zzZB9) : this.zzWOc(true, this.zzZB9));
        } while (this.zzZB9 != null && !this.zzA3.zzZsn(this.zzZB9));
        return node2;
    }

    private Node zzZ85(Node node, boolean bl) throws Exception {
        while ((this.zzWYv ? this.zzYn3(bl, node) : (node = this.zzA3.zzR5() ? this.zzXlm(bl, node) : this.zzWOc(bl, node))) != null && !this.zzA3.zzZsn(node)) {
        }
        return node;
    }

    private Node zzYn3(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWva);
        }
        return node.previousPreOrder(this.zzWva);
    }

    private Node zzWOc(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWva) {
                return this.zzWva.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWva) {
            return this.zzWva.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzXlm(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWva ? this.zzWva.zzX3w() : node.zzVWh();
        } else {
            Node node3 = node2 = node == this.zzWva ? this.zzWva.zzW51() : node.zzWUE();
        }
        if (node2 == this.zzWva.getNextSibling() || node2 == this.zzWva.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzX0f() {
        if (this.zzZ23 != this.zzWNy()) {
            this.zzcS();
        }
    }

    private void zzcS() {
        this.zzZ23 = this.zzWNy();
        this.zzYkD = -1;
        this.zzOp = this.zzWva;
        this.zzXfG = -1;
    }

    private int zzWNy() {
        if (this.zzX3u != null) {
            return this.zzX3u.zzXpL();
        }
        return 0;
    }

    public int getCount() {
        this.zzX0f();
        if (this.zzXfG == -1) {
            this.zzXfG = zzLD.zzYn3(this);
        }
        return this.zzXfG;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZB9;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWva;
    }
}

