/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzW1g;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.internal.zzWOt;
import com.aspose.words.internal.zzWPq;
import com.aspose.words.internal.zzXAb;
import com.aspose.words.internal.zzXrY;
import com.aspose.words.internal.zzY5F;
import com.aspose.words.internal.zzZ7C;
import com.aspose.words.internal.zzZch;
import com.aspose.words.internal.zzZcp;
import com.aspose.words.internal.zzZx6;
import com.aspose.words.internal.zzq7;
import com.aspose.words.zz9u;
import com.aspose.words.zzB8;
import com.aspose.words.zzGB;
import com.aspose.words.zzWCe;
import com.aspose.words.zzWXI;
import com.aspose.words.zzWpu;
import com.aspose.words.zzXSz;
import com.aspose.words.zzXqH;
import com.aspose.words.zzZSC;
import com.aspose.words.zzbh;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYn3(zzXrY zzXrY2, zzXrY zzXrY3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWAB.zzWOc((Object)zzXrY2, "srcStream");
        zzWAB.zzWOc((Object)zzXrY3, "dstStream");
        zzWAB.zzWOc((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzWOc(zzXrY2, zzXrY3, certificateHolder, signOptions);
        zzXrY3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYn3(zzXrY.zzWOc(srcStream), (zzXrY)zzXrY.zzXlm(dstStream), certHolder, signOptions);
    }

    private static void zzWOc(zzXrY zzXrY2, zzXrY zzXrY3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzXlm(digitalSignature);
        }
        if (zzXSz.zzXVB(zzXrY2)) {
            DigitalSignatureUtil.zzYn3(zzXrY2, zzXrY3, digitalSignature, true);
            return;
        }
        zzXSz zzXSz2 = new zzXSz();
        zzXrY zzXrY4 = zzXrY2;
        zzXSz zzXSz3 = zzXSz2;
        FileFormatInfo fileFormatInfo = zzXSz2.zzWOc(zzXrY4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZx6 zzZx62 = new zzZx6(zzXrY2);
                int n = fileFormatInfo.zziR() == 1 ? 1 : 2;
                zzB8.zzYn3(zzZx62, digitalSignature, n);
                zzXrY3.zzZ42(0L);
                zzZx62.zzYkS(zzXrY3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYn3(fileFormatInfo.zzy0(), zzXrY3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYn3(zzXrY2, zzXrY3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzYn3(zzXrY2, zzXrY3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWAB.zzYn3(srcFileName, "srcFileName");
        zzWAB.zzYn3(dstFileName, "dstFileName");
        try (zzZ7C zzZ7C2 = zzWAB.zzWOc(srcFileName, 3, 1);){
            try (zzZ7C zzZ7C3 = zzWAB.zzWOc(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYn3((zzXrY)zzZ7C2, (zzXrY)zzZ7C3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzq7 zzq72 = zzXrY.zzXlm(dstStream);
        zzXrY zzXrY2 = zzXrY.zzWOc(srcStream);
        DigitalSignatureUtil.zzYn3(zzXrY2, (zzXrY)zzq72, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZ7C zzZ7C2 = zzWAB.zzWOc(srcFileName, 3, 1);){
            try (zzZ7C zzZ7C3 = zzWAB.zzWOc(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzAY(zzZ7C2, zzZ7C3);
            }
            return;
        }
    }

    private static void zzAY(zzXrY zzXrY2, zzXrY zzXrY3) throws Exception {
        zzXSz zzXSz2 = new zzXSz();
        zzXrY zzXrY4 = zzXrY2;
        zzXSz zzXSz3 = zzXSz2;
        FileFormatInfo fileFormatInfo = zzXSz2.zzWOc(zzXrY4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZx6 zzZx62 = new zzZx6(zzXrY2);
                zzZx62.zzFx().zzWOa("_xmlsignatures");
                zzZx62.zzFx().zzWOa("_signatures");
                zzXrY3.zzYK9(0L);
                zzZx62.zzYkS(zzXrY3);
                zzXrY zzXrY5 = zzXrY3;
                zzXrY5.zzZ42(zzXrY5.zzQI());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZcp zzZcp2 = new zzZcp(zzXrY2);
                zzZch zzZch2 = zzZcp2.zzYn3(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzZch2 != null) {
                    for (zzWPq zzWPq2 : zzZch2.zzZlc()) {
                        String string = zzZch2.zzYn3(zzWPq2);
                        zzZcp2.zzWRN().remove(string);
                    }
                    zzZcp2.zzWRN().remove(zzZch2.getName());
                    zzWPq zzWPq3 = zzZcp2.zzZlc().zzWoh("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZcp2.zzZlc().remove(zzWPq3.getId());
                    zzZcp2.zzwl();
                }
                zzXrY3.zzYK9(0L);
                zzZcp2.zzYkS(zzXrY3);
                zzXrY zzXrY6 = zzXrY3;
                zzXrY6.zzZ42(zzXrY6.zzQI());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzAY(zzXrY.zzWOc(srcStream), zzXrY.zzXlm(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZ7C zzZ7C2 = zzWAB.zzWOc(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXXd(zzZ7C2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXXd(zzXrY zzXrY2) throws Exception {
        if (zzXSz.zzXVB(zzXrY2)) {
            return DigitalSignatureUtil.zzXQ0(zzXrY2);
        }
        zzXSz zzXSz2 = new zzXSz();
        zzXrY zzXrY3 = zzXrY2;
        zzXSz zzXSz3 = zzXSz2;
        FileFormatInfo fileFormatInfo = zzXSz2.zzWOc(zzXrY3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXrY2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXXd(zzXrY.zzWOc(stream));
    }

    static zzY5F zzYn3(zzZx6 zzZx62, String string) throws Exception {
        zzWpu zzWpu2 = new zzWpu(zzZx62);
        if (zzWpu2.zzWKq()) {
            zzY5F zzY5F2 = zzWpu2.zzXvR(string);
            return zzY5F2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzW7H(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzW1g.zzWOc("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYzF(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzW7H(n);
    }

    private static void zzYn3(zzXrY zzXrY2, zzXrY zzXrY3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZcp zzZcp2 = new zzZcp(zzXrY2);
        zzWXI zzWXI2 = bl ? new zzbh(zzZcp2) : new zz9u(zzZcp2);
        zzWXI2.zzWOc(digitalSignature);
        zzXrY3.zzZ42(0L);
        zzZcp2.zzYkS(zzXrY3);
    }

    private static void zzYn3(zzXrY zzXrY2, zzXrY zzXrY3, DigitalSignature digitalSignature) throws Exception {
        zzXqH zzXqH2 = new zzXqH(zzXrY2);
        zzGB zzGB2 = new zzGB(zzXqH2);
        zzGB2.zzWOc(digitalSignature);
        zzXrY3.zzZ42(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXrY zzXrY4 = zzXrY3;
        zzXqH zzXqH3 = zzXqH2;
        zzXqH3.zzYn3(zzXrY4, string, null);
    }

    private static void zzYn3(zzZx6 zzZx62, zzXrY zzXrY2, DigitalSignature digitalSignature, String string) throws Exception {
        zzY5F zzY5F2 = DigitalSignatureUtil.zzYn3(zzZx62, string);
        zzY5F zzY5F3 = new zzY5F();
        DigitalSignatureUtil.zzYn3((zzXrY)zzY5F2, (zzXrY)zzY5F3, digitalSignature, false);
        zzZx6 zzZx63 = zzWpu.zzXlm(zzY5F3, string);
        zzZx63.zzYkS(zzXrY2);
    }

    private static DigitalSignatureCollection zzXQ0(zzXrY zzXrY2) throws Exception {
        zzXrY2.zzYK9(0L);
        zzZcp zzZcp2 = new zzZcp(zzXrY2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzZch zzZch2 = zzZcp2.zzYn3(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzZch2 != null) {
            for (zzWPq zzWPq2 : zzZch2.zzZlc()) {
                String string = zzZch2.zzYn3(zzWPq2);
                zzZch zzZch3 = zzZcp2.zzXYN(string);
                zzZch zzZch4 = zzZcp2.zzYn3(zzZch3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWOt zzWOt2 = zzXAb.zzXfG(zzZch4.zzW1n().zzWaC());
                zzZSC.zzYn3(zzZch3.zzW7U(), zzWOt2, new zzWCe(zzZcp2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

