/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXdQ;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzXTf;
import com.aspose.words.net.System.Data.zzYhn;
import com.aspose.words.net.System.Data.zzZUB;
import com.aspose.words.net.System.Data.zzr1;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzW0f;
    private final DataColumnCollection zzaV;
    private final ConstraintCollection zzXHD;
    private final zzZUB zzb7;
    private ResultSet zzZWH;
    private String zzXP6;
    private DataSet zzZXv;
    private String zzWDF;
    private UniqueConstraint zzYkh;
    private boolean zzZ0;
    private final List<DataTableEventListener> zzmO;
    private final Set<DataRow> zzWFq;
    private DataRelationCollection zzVQd;

    public DataTable() {
        this.zzW0f = new DataRowCollection(this);
        this.zzaV = new DataColumnCollection(this);
        this.zzXHD = new ConstraintCollection(this);
        this.zzb7 = new zzZUB(this);
        this.zzWDF = "";
        this.zzZ0 = true;
        this.zzmO = new ArrayList<DataTableEventListener>();
        this.zzWFq = new HashSet<DataRow>();
        this.zzVQd = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzW0f = new DataRowCollection(this);
        this.zzaV = new DataColumnCollection(this);
        this.zzXHD = new ConstraintCollection(this);
        this.zzb7 = new zzZUB(this);
        this.zzWDF = "";
        this.zzZ0 = true;
        this.zzmO = new ArrayList<DataTableEventListener>();
        this.zzWFq = new HashSet<DataRow>();
        this.zzVQd = new DataRelationCollection();
        this.zzXP6 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYhn.zzXWH(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzW0f = new DataRowCollection(this);
        this.zzaV = new DataColumnCollection(this);
        this.zzXHD = new ConstraintCollection(this);
        this.zzb7 = new zzZUB(this);
        this.zzWDF = "";
        this.zzZ0 = true;
        this.zzmO = new ArrayList<DataTableEventListener>();
        this.zzWFq = new HashSet<DataRow>();
        this.zzVQd = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzZWH = resultSet;
        this.zzXP6 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzZWH != null) {
            if (this.zzZWH.getStatement() != null) {
                this.zzZWH.getStatement().getConnection().close();
            }
            this.zzZWH = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXP6;
    }

    public void setTableName(String tableName) {
        this.zzXP6 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzaV.getCount();
    }

    public String getColumnName(int index) {
        return this.zzaV.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzZWH;
    }

    public DataSet getDataSet() {
        return this.zzZXv;
    }

    final void zzX0q(DataSet dataSet) {
        this.zzZXv = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZXv.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzVQd.add(dataRelation);
        }
        return this.zzVQd;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZXv.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzW0f;
    }

    public DataColumnCollection getColumns() {
        return this.zzaV;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXHD;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYkh == null) {
            return new DataColumn[0];
        }
        return this.zzYkh.getColumns();
    }

    final void zzZUB(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYkh != null) {
                this.zzYkh.zzZrp(false);
                this.getConstraints().remove(this.zzYkh);
                this.zzYkh = null;
            }
            return;
        }
        if (this.zzYkh != null && DataColumn.areColumnSetsTheSame(value, this.zzYkh.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXWH(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYkh != null) {
            this.zzYkh.zzZrp(false);
            this.getConstraints().remove(this.zzYkh);
            this.zzYkh = null;
        }
        UniqueConstraint.zzXWH(this.getConstraints(), uniqueConstraint);
        this.zzYkh = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWDF;
    }

    public void setNamespace(String namespace) {
        this.zzWDF = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZ0;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZ0 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWFq.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYhn.zzXWH(this.getResultSet(), this);
            zzYhn.zzYhn(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXdQ.zzX0q(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYhn.zzYVD(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzmO.contains(listener)) {
            this.zzmO.add(listener);
        }
    }

    public void removeEventListener(zzXTf listener) {
        if (this.zzmO.contains(listener)) {
            this.zzmO.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzmO.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWFq.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzmO) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWFq.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzmO) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWFq.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzmO) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzmO) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzmO) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzr1 zzXWH(zzYhn[] zzYhnArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYhnArray.length];
        for (int i = 0; i < zzYhnArray.length; ++i) {
            dataColumnArray[i] = zzYhnArray[i].zzZWa();
        }
        DataTable dataTable = this;
        zzr1 zzr12 = dataTable.zzb7.zzX0q(dataColumnArray);
        if (zzr12 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzr12;
    }

    final zzZUB zzXEJ() {
        return this.zzb7;
    }

    final Set<DataRow> zzW4s() {
        return this.zzWFq;
    }
}

