/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz0p;
import com.aspose.words.internal.zzVX2;
import com.aspose.words.internal.zzVs;
import com.aspose.words.internal.zzXBH;
import com.aspose.words.internal.zzXJD;
import com.aspose.words.internal.zzYsd;
import com.aspose.words.internal.zzZIw;
import com.aspose.words.zzYKK;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzYXy;
    private zzYKK zzYSw;

    Watermark(Document doc, zzYKK watermarkProvider) {
        this.zzYXy = doc;
        this.zzYSw = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzVTe(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXWH(text, textWatermarkOptions, this.zzYXy);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzVs.zzYhn((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzYXy, 75);
        shape.getImageData().setImage(image);
        this.zzXWH(shape, options, this.zzYXy);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzVs.zzYhn((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzYXy, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXWH(shape, options, this.zzYXy);
    }

    public final int getType() {
        Shape shape = this.zzYSw.get();
        if (shape == null) {
            return 2;
        }
        shape.zzXCB();
        if (shape.zzXtE()) {
            return 0;
        }
        if (shape.zzZ1a()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzYSw.add(shape);
    }

    public final void remove() {
        this.zzYSw.remove();
    }

    private static void zzVTe(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzXJD.zz1B(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzVs.zzXWH(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXWH(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYhn(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzYVD(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYhn(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzUU() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzyb()) / d2) > (double)(f = pageSetup.zztL())) {
            d = (double)f / d3;
        }
        shape.zzoE(zzXBH.zzXTf(d2 * d, 2, zzYsd.zzY7t));
        shape.zzXnv(zzXBH.zzXTf(d3 * d, 2, zzYsd.zzY7t));
    }

    private Shape zzXWH(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXWH(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzYVD(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXWH(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZmT() ? 1.0f : textWatermarkOptions.getFontSize();
        zz0p zz0p2 = document.zzWO2().zzXTf(shape.getTextPath().getFontFamily(), f, 0);
        long l = zz0p2.zzWee(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZmT()) {
            l = Watermark.zzXWH(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzoE(zzXBH.zzXTf(Float.intBitsToFloat(n), 2, zzYsd.zzY7t));
        shape.zzXnv(zzXBH.zzXTf(zzZIw.zzXPn(l), 2, zzYsd.zzY7t));
    }

    private static long zzXWH(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzyb();
        float f2 = pageSetup.zztL();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZIw.zzXPn(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZIw.zzWYs(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZIw.zzXPn(l) >= Float.intBitsToFloat(n)) {
            return zzZIw.zzWYs(f2 / f3, f2);
        }
        float f6 = f;
        return zzZIw.zzWYs(f6, f6 * f3);
    }

    private static void zzYVD(Shape shape, String string) {
        shape.setName(zzVX2.zzYhn("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

