/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzVX2;
import com.aspose.words.internal.zzVs;
import com.aspose.words.zzYJq;
import com.aspose.words.zzZ71;
import com.aspose.words.zzf4;

public final class Section
extends CompositeNode<Node>
implements zzZ71 {
    private zzf4 zzYtN;
    private PageSetup zzXTK;
    private HeaderFooterCollection zzep;

    public Section(DocumentBase doc) {
        this(doc, new zzf4());
    }

    Section(DocumentBase doc, zzf4 sectPr) {
        super(doc);
        this.zzYtN = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzep == null) {
            this.zzep = new HeaderFooterCollection(this);
        }
        return this.zzep;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXTK == null) {
            Section section = this;
            this.zzXTK = new PageSetup(section, section.getDocument().zzZXN(), this.getDocument().getStyles(), new zzXWH(this));
        }
        return this.zzXTK;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzWBA();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYHP(!value);
    }

    final zzf4 zz0q() {
        return this.zzYtN;
    }

    final void zzXTf(zzf4 zzf42) {
        this.zzYtN = zzf42;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXWH(boolean bl, zzYJq zzYJq2) {
        zzf4 zzf42;
        Section section = (Section)super.zzXWH(bl, zzYJq2);
        zzf4 zzf43 = this.zzYtN;
        section.zzYtN = zzf42 = (zzf4)zzf43.zzW0c();
        section.zzXTK = null;
        section.zzep = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXWH(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzYhn(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzX0q(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzX0q(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYTg(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzYjy(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYTg(n) == null;
            }
        }
        return false;
    }

    final void zzXTf(Shape shape, boolean bl) throws Exception {
        this.zzXWH(shape, 4, bl);
        this.zzXWH(shape, 0, bl);
        this.zzXWH(shape, 1, bl);
    }

    private void zzXWH(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzZi6());
        shape2.setName(zzVX2.zzYhn("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzXnX() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzWz1()) {
                if (!shape.zzXCB()) continue;
                shape.remove();
            }
        }
    }

    private void zzX0q(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYhn(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYtN.zzWN6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZXN().zzZMU.zzWKF(key);
        }
        return zzf4.zzYR2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYtN.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZXN().zzZMU.zzXeQ(key, value);
            return;
        }
        this.zzYtN.zzXeQ(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYtN.clear();
    }

    final boolean zzWex() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zztc() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzXWH
    implements zzZ71 {
        private Section zzXEr;

        zzXWH(Section section) {
            this.zzXEr = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzGg().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzGg().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzGg().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZ71 zzGg() {
            Document document = zzVs.zzXWH((Object)this.zzXEr.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXEr;
        }
    }
}

