/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXln;
import com.aspose.words.internal.zzY7z;

public abstract class SaveOptions {
    private boolean zzZRy;
    private IDocumentSavingCallback zzWot;
    private boolean zzKc = true;
    private boolean zzXNe = false;
    private boolean zzX3w = true;
    private boolean zzZuZ;
    private String zzqt;
    private boolean zzXuG;
    private boolean zzXGQ = false;
    private boolean zzXu7 = true;
    private int zzZ6K = 1;
    private int zzYVP = 1;
    private int zzWqm = 0;
    private String zzWi5 = "";
    private boolean zzWeX = true;
    private boolean zzW0e = true;
    private boolean zzX6Y;
    private boolean zzYVv;
    private int zzXp6 = 0;
    private boolean zzdo = true;
    private boolean zzXxw = false;
    private boolean zzY5S = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzxj() {
        return false;
    }

    boolean zzYah() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzX3w;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzX3w = value;
    }

    public String getTempFolder() {
        return this.zzqt;
    }

    public void setTempFolder(String value) {
        this.zzqt = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZuZ;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZuZ = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXuG;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXuG = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXGQ;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXGQ = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzXu7;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzXu7 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZ6K;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZ6K = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzWqm;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzWqm = value;
    }

    public int getImlRenderingMode() {
        return this.zzYVP;
    }

    public void setImlRenderingMode(int value) {
        this.zzYVP = value;
    }

    public String getDefaultTemplate() {
        return this.zzWi5;
    }

    public void setDefaultTemplate(String value) {
        this.zzWi5 = value;
    }

    public boolean getUpdateFields() {
        return this.zzWeX;
    }

    public void setUpdateFields(boolean value) {
        this.zzWeX = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzX6Y;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzX6Y = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzYVv;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzYVv = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzXxw;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzXxw = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXNe;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXNe = value;
    }

    final boolean zzXVk() {
        return this.zzW0e;
    }

    final boolean zzMt() {
        return this.zzdo;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzXin(zzXln.zzWr9(zzY7z.zzYC(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzXp6;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzXp6 = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzWot;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzWot = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZRy;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZRy = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzY5S;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzY5S = value;
    }

    final boolean zzYMC() {
        return this.zzKc;
    }
}

