/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzVs;
import com.aspose.words.zzVOs;
import com.aspose.words.zzXxQ;
import com.aspose.words.zzZsK;
import com.aspose.words.zzld;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZsK,
Iterable<T> {
    private Node zzZlX;
    private CompositeNode zzWLe;
    private DocumentBase zzYz6;
    private boolean zzHp;
    private int zzWnR;
    private int zzZru;
    private Node zzYCT;
    private int zzXiU;
    private zzld zzX54;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzVOs.zzX4t(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzVOs(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzld matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzWLe = container;
        this.zzYz6 = container.getDocument();
        this.zzX54 = matcher;
        this.zzHp = isDeep;
        this.zzBp();
    }

    public Node get(int index) {
        try {
            this.zzYPU();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZru == index) {
                return this.zzYCT;
            }
            int n = index - this.zzZru;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzxn(nodeCollection.zzYCT, n);
            if (node != null) {
                this.zzZru = index;
                this.zzYCT = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzHp) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWLe.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzHp) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWLe.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzW80();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXxQ(this);
    }

    final <TNode extends Node> zzXxQ<TNode> zzXzt() {
        return new zzXxQ(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzW80() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzVs.zzXWH(arrayList, node);
        }
        return arrayList;
    }

    private Node zzxn(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZHE(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzOi(curNode, true);
    }

    private Node zzOi(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzZlX = node;
        do {
            node2 = this.zzZlX;
            Node node3 = this.zzHp ? this.zzXWH(true, this.zzZlX) : (this.zzZlX = this.zzX54.zzTe() ? this.zzXTf(true, this.zzZlX) : this.zzYhn(true, this.zzZlX));
        } while (this.zzZlX != null && !this.zzX54.zzZdz(this.zzZlX));
        return node2;
    }

    private Node zzZHE(Node node, boolean bl) throws Exception {
        while ((this.zzHp ? this.zzXWH(bl, node) : (node = this.zzX54.zzTe() ? this.zzXTf(bl, node) : this.zzYhn(bl, node))) != null && !this.zzX54.zzZdz(node)) {
        }
        return node;
    }

    private Node zzXWH(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWLe);
        }
        return node.previousPreOrder(this.zzWLe);
    }

    private Node zzYhn(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWLe) {
                return this.zzWLe.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWLe) {
            return this.zzWLe.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzXTf(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWLe ? this.zzWLe.zzYIs() : node.zzZ8N();
        } else {
            Node node3 = node2 = node == this.zzWLe ? this.zzWLe.zzWbU() : node.zzVYr();
        }
        if (node2 == this.zzWLe.getNextSibling() || node2 == this.zzWLe.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYPU() {
        if (this.zzWnR != this.zzZ3n()) {
            this.zzBp();
        }
    }

    private void zzBp() {
        this.zzWnR = this.zzZ3n();
        this.zzZru = -1;
        this.zzYCT = this.zzWLe;
        this.zzXiU = -1;
    }

    private int zzZ3n() {
        if (this.zzYz6 != null) {
            return this.zzYz6.zzvx();
        }
        return 0;
    }

    public int getCount() {
        this.zzYPU();
        if (this.zzXiU == -1) {
            this.zzXiU = zzXxQ.zzXWH(this);
        }
        return this.zzXiU;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZlX;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWLe;
    }
}

