/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzVs;
import com.aspose.words.internal.zzX69;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVZo;
import com.aspose.words.zzXEv;
import com.aspose.words.zzYJq;
import com.aspose.words.zzZgD;
import com.aspose.words.zzsV;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzZ9R;
    private Node zzYfj;
    private Node zzZPy;
    private int zzWCu;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzX0q(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZ9R == null) {
            return null;
        }
        if (this.zzZ9R.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzZ9R;
    }

    final CompositeNode zzXjY() {
        if (zzXEv.zzZBl(this.getParentNode())) {
            return this.getParentNode().zzXjY();
        }
        return this.getParentNode();
    }

    final CompositeNode zzXSa() {
        if (zzXEv.zzZBl(this.getParentNode()) || zzXEv.zzZeS(this.getParentNode())) {
            return this.getParentNode().zzXSa();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzZ9R != null) {
            return this.zzZ9R.getDocument();
        }
        return null;
    }

    final Document zzZbN() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzB() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zznJ();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzZPy;
    }

    final Node zzWHE() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzXEv.zzWfD((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzVYr() {
        Node node = zzXEv.zzZvG(this.getPreviousSibling(), false);
        if (node == null && zzXEv.zzZBl(this.getParentNode())) {
            node = this.getParentNode().zzVYr();
        }
        return node;
    }

    final Node zzZ8N() {
        Node node = zzXEv.zzKW(this.getNextSibling(), false);
        if (node == null && zzXEv.zzZBl(this.getParentNode())) {
            node = this.getParentNode().zzZ8N();
        }
        return node;
    }

    final CompositeNode zzIK() {
        Node node = this;
        while ((node = node.zzVYr()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zz44() {
        Node node = this;
        while ((node = node.zzZ8N()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYfj;
    }

    final Node zzXa7() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzXEv.zzWfD((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXx9() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXi9() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzpq() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzXEv.zzX5v(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWq3() {
        return this.zzYfj;
    }

    final void zzZuv(Node node) {
        this.zzYfj = node;
    }

    final Node zzy5() {
        return this.zzZPy;
    }

    final void zzRu(Node node) {
        this.zzZPy = node;
    }

    final Node zzX3d() {
        Node node = this;
        if (node.zzYfj != null) {
            node = this;
            return node.zzYfj;
        }
        return this.getParentNode();
    }

    final int zzY52() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzXEv.zzYBx(this);
        boolean bl2 = zzXEv.zzWMq(this);
        boolean bl3 = zzXEv.zzYMr(this);
        boolean bl4 = zzXEv.zzZnw(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzY52() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzY52() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXWH(isCloneChildren, new zzXWH(this));
    }

    Node zzXWH(boolean bl, zzYJq zzYJq2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZ9R != null) {
            node.zzZ9R = this.getDocument().zzX3H();
        }
        node.zzYfj = null;
        node.zzZPy = null;
        if (zzYJq2 != null) {
            zzYJq2.zzX0q(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZv8(StringBuilder stringBuilder) {
        zzVs.zzYhn(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzXDS(Node node) {
        this.zzZ9R = node != null ? node : this.getDocument().zzX3H();
    }

    final void zzX0q(DocumentBase documentBase) {
        this.zzZ9R = documentBase != null ? documentBase.zzX3H() : null;
    }

    final boolean zzWv1(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZun() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzXW3(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzY9c(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZdz(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYte(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzVZo zzVZo2 = zzXEv.zzVUi(saveFormat);
        return zzVZo2.zzZ1C(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzVZo zzVZo2 = zzXEv.zzXWH(saveOptions);
        return zzVZo2.zzZ1C(this);
    }

    final Node zzZZ2(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzXEv.zzXdH(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzsV zzZj5() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzsV.zzWBl(node);
        }
        return zzsV.zzYsl(this.getParentNode());
    }

    final zzsV zzXHz() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzsV.zzYsl(node);
        }
        return zzsV.zzWBl(this.getParentNode());
    }

    final boolean zzZOA(Node node) {
        return Node.zzW4f(this, node);
    }

    final boolean zzZTb() {
        return this.getAncestor(1) == null;
    }

    static Node zzZti(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzX69<Node> zzX692 = Node.zzYcm(node);
        zzX69<Node> zzX693 = Node.zzYcm(node2);
        return Node.zzXWH(zzX692, zzX693);
    }

    static boolean zzW4f(Node node, Node node2) {
        zzX69<Node> zzX692;
        if (node == null || node2 == null) {
            return false;
        }
        zzX69<Node> zzX693 = Node.zzYcm(node);
        Node node3 = Node.zzXWH(zzX693, zzX692 = Node.zzYcm(node2));
        if (node3 == null) {
            return false;
        }
        zzX69<Node> zzX694 = zzX693;
        if (zzX694.size() == 0 || (zzX694 = zzX692).size() == 0) {
            zzX694 = zzX692;
            boolean bl = zzX694.size() > 0;
            return bl;
        }
        Object e = zzX693.peek();
        Object e2 = zzX692.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzX69<Node> zzYcm(Node node) {
        zzX69<Node> zzX692 = new zzX69<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzX692.push(node2);
        }
        return zzX692;
    }

    private static Node zzXWH(zzX69<Node> zzX692, zzX69<Node> zzX693) {
        Node node = null;
        while (zzX692.peek() == zzX693.peek()) {
            node = (Node)zzX692.pop();
            zzX693.pop();
            zzX69<Node> zzX694 = zzX692;
            if (zzX694.size() != 0 && (zzX694 = zzX693).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzWCu;
    }

    public void setCustomNodeId(int value) {
        this.zzWCu = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzWee(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zz7g(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzX42(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zz7g(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zz7g(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXWH
    implements zzYJq {
        private Node zzoB;
        private HashMap<Integer, Integer> zzYmD;

        zzXWH(Node node) {
            this.zzoB = node;
        }

        @Override
        public final void zzX0q(Node node, Node node2) {
            if (node == this.zzoB) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzZgD zzZgD2 = (zzZgD)((Object)node2);
            if (this.zzYmD == null) {
                this.zzYmD = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzVs.zzXWH(this.zzYmD, Integer.valueOf(zzZgD2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzWOL();
                zzVs.zzYhn(this.zzYmD, Integer.valueOf(zzZgD2.getIdInternal()), Integer.valueOf(n));
            }
            zzZgD2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzVs.zzXWH(this.zzYmD, Integer.valueOf(zzZgD2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzZgD2.setParentIdInternal(n2);
            }
        }
    }
}

