/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzVs;
import com.aspose.words.internal.zzX1t;
import com.aspose.words.internal.zzXGZ;
import com.aspose.words.internal.zzXJD;
import com.aspose.words.internal.zzXln;
import com.aspose.words.internal.zzkY;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZ0B;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZQD = new HashMap();
    private static HashMap<Integer, Integer> zzWmC = new HashMap();
    private static HashMap<Integer, Integer> zzYNx = new HashMap();
    private static HashMap<Integer, Integer> zzm0 = new HashMap();
    private static HashMap<Integer, Integer> zzYmA = new HashMap();
    private static HashMap<Integer, Integer> zzci = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzVs.zzXWH(fileName, "fileName");
        try (zzkY zzkY2 = zzVs.zzZv8(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZpl(zzkY2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZpl(zzX1t.zzXWH(stream));
    }

    static FileFormatInfo zzZpl(zzXGZ zzXGZ2) throws Exception {
        if (zzXGZ2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZ0B zzZ0B2 = new zzZ0B();
            zzXGZ zzXGZ3 = zzXGZ2;
            zzZ0B zzZ0B3 = zzZ0B2;
            return zzZ0B2.zzYhn(zzXGZ3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzXTf(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZVz(zzXln.zzvH(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzXin(zzXln.zzvH(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXJD.zzVPw(string = zzXln.zzWmy(FileFormatUtil.zzX0k(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZVz(FileFormatUtil.zzW71(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzXin(FileFormatUtil.zzX0k(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXln.zzWmy(FileFormatUtil.zzW71(saveFormat));
        if (zzXJD.zzVPw(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzXin(zzXln.zzWr9(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXln.zzWmy(FileFormatUtil.zzXlM(imageType));
    }

    static Exception zzXTf(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzbK(int n) {
        return zzXln.toString(FileFormatUtil.zzW71(n));
    }

    static int zzXin(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzVs.zzXWH(zzYmA, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzTg(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzVs.zzXWH(zzci, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzVP7(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzX0k(int n) {
        return zzVs.zzXWH(zzZQD, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzW71(int n) {
        return zzVs.zzXWH(zzWmC, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXlM(int n) {
        return zzVs.zzXWH(zzYNx, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZVz(int n) {
        return zzVs.zzXWH(zzm0, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzW8e(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzVs.zzYhn(zzYmA, Integer.valueOf(n), Integer.valueOf(n2));
            zzVs.zzYhn(zzWmC, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzm0.containsKey(n)) {
                zzVs.zzYhn(zzm0, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzVs.zzYhn(zzZQD, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzVs.zzYhn(zzci, Integer.valueOf(n), Integer.valueOf(n4));
            zzVs.zzYhn(zzYNx, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzW8e(11, 10, 10, 1);
        FileFormatUtil.zzW8e(11, 0, 0, 1);
        FileFormatUtil.zzW8e(12, 11, 11, 1);
        FileFormatUtil.zzW8e(13, 20, 20, 1);
        FileFormatUtil.zzW8e(13, 0, 254, 1);
        FileFormatUtil.zzW8e(14, 21, 21, 1);
        FileFormatUtil.zzW8e(15, 22, 22, 1);
        FileFormatUtil.zzW8e(16, 23, 23, 1);
        FileFormatUtil.zzW8e(18, 24, 24, 1);
        FileFormatUtil.zzW8e(19, 25, 25, 1);
        FileFormatUtil.zzW8e(20, 26, 26, 1);
        FileFormatUtil.zzW8e(21, 27, 27, 1);
        FileFormatUtil.zzW8e(24, 30, 30, 1);
        FileFormatUtil.zzW8e(17, 31, 31, 1);
        FileFormatUtil.zzW8e(25, 50, 50, 1);
        FileFormatUtil.zzW8e(26, 45, 255, 1);
        FileFormatUtil.zzW8e(27, 51, 51, 1);
        FileFormatUtil.zzW8e(28, 0, 52, 1);
        FileFormatUtil.zzW8e(29, 0, 53, 1);
        FileFormatUtil.zzW8e(31, 0, 54, 1);
        FileFormatUtil.zzW8e(22, 60, 60, 1);
        FileFormatUtil.zzW8e(23, 61, 61, 1);
        FileFormatUtil.zzW8e(34, 40, 64, 1);
        FileFormatUtil.zzW8e(41, 47, 255, 1);
        FileFormatUtil.zzW8e(42, 48, 255, 1);
        FileFormatUtil.zzW8e(35, 41, 255, 1);
        FileFormatUtil.zzW8e(36, 46, 255, 1);
        FileFormatUtil.zzW8e(38, 42, 255, 1);
        FileFormatUtil.zzW8e(37, 44, 255, 1);
        FileFormatUtil.zzW8e(30, 52, 255, 1);
        FileFormatUtil.zzW8e(32, 70, 62, 1);
        FileFormatUtil.zzW8e(33, 73, 63, 1);
        FileFormatUtil.zzW8e(39, 71, 255, 1);
        FileFormatUtil.zzW8e(8, 100, 255, 1);
        FileFormatUtil.zzW8e(9, 105, 255, 1);
        FileFormatUtil.zzW8e(6, 101, 255, 6);
        FileFormatUtil.zzW8e(7, 102, 255, 7);
        FileFormatUtil.zzW8e(5, 104, 255, 5);
        FileFormatUtil.zzW8e(4, 0, 255, 4);
        FileFormatUtil.zzW8e(3, 0, 255, 3);
        FileFormatUtil.zzW8e(40, 72, 255, 1);
        FileFormatUtil.zzW8e(2, 103, 255, 2);
    }
}

