/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzLn;
import com.aspose.words.internal.zzVVw;
import com.aspose.words.internal.zzVX2;
import com.aspose.words.internal.zzVs;
import com.aspose.words.internal.zzW92;
import com.aspose.words.internal.zzWD5;
import com.aspose.words.internal.zzX4x;
import com.aspose.words.internal.zzX69;
import com.aspose.words.internal.zzXGZ;
import com.aspose.words.internal.zzXJD;
import com.aspose.words.internal.zzXjE;
import com.aspose.words.internal.zzY7z;
import com.aspose.words.internal.zzYRK;
import com.aspose.words.internal.zzYYS;
import com.aspose.words.internal.zzYZX;
import com.aspose.words.internal.zzYeG;
import com.aspose.words.internal.zzZIw;
import com.aspose.words.internal.zzib;
import com.aspose.words.zz8x;
import com.aspose.words.zzD7;
import com.aspose.words.zzHm;
import com.aspose.words.zzOi;
import com.aspose.words.zzVYM;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzW0X;
import com.aspose.words.zzW4D;
import com.aspose.words.zzW9z;
import com.aspose.words.zzWGb;
import com.aspose.words.zzWX7;
import com.aspose.words.zzWgw;
import com.aspose.words.zzWiS;
import com.aspose.words.zzWo8;
import com.aspose.words.zzWp9;
import com.aspose.words.zzWuX;
import com.aspose.words.zzWyY;
import com.aspose.words.zzX8o;
import com.aspose.words.zzXEv;
import com.aspose.words.zzXQm;
import com.aspose.words.zzXUW;
import com.aspose.words.zzXbf;
import com.aspose.words.zzXio;
import com.aspose.words.zzXyD;
import com.aspose.words.zzYBZ;
import com.aspose.words.zzYU6;
import com.aspose.words.zzYVx;
import com.aspose.words.zzYpj;
import com.aspose.words.zzYry;
import com.aspose.words.zzZ3R;
import com.aspose.words.zzZ9O;
import com.aspose.words.zzZFa;
import com.aspose.words.zzZGM;
import com.aspose.words.zzZGc;
import com.aspose.words.zzZVZ;
import com.aspose.words.zzZZX;
import com.aspose.words.zzZfM;
import com.aspose.words.zzZgh;
import com.aspose.words.zzZs;
import com.aspose.words.zzf4;
import com.aspose.words.zzq8;
import com.aspose.words.zzsV;
import com.aspose.words.zzt5;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzVYM,
zzXUW,
zzZZX {
    private Document zzYXy;
    private Node zzY0L;
    private Node zzWpR;
    private zzWyY zzZcy;
    private Font zzXkC;
    private zzX69<zzWyY> zzeD;
    private zzX69<zzWGb> zzZWC;
    private zzX69<zzXWH> zzW7Y;
    private zzZfM zzWU5 = zzZfM.zzXbg();
    private zzW9z zzVI = new zzW9z();
    private RowFormat zzXCm;
    private CellFormat zzxi;
    private zzX69<zzt5> zzZ8z;
    private int zzVOt = 0;
    private int zzX2w = -1;
    private int zzXww;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzXeQ(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzXeQ(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzXeQ(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXWH(documentBuilder.getCurrentSection(), zzZGc.zzCN(headerFooterType), 0, 0);
    }

    private void zzXeQ(int n, int n2, int n3, int n4) {
        this.zzYXy.ensureMinimum();
        Section section = (Section)this.zzYXy.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXWH(section, 1, n3, n4);
    }

    private void zzXWH(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZGc.zzWmX(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzYXy, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzYXy));
            }
        }
        this.zzXWH(story, n2, n3);
    }

    private void zzXWH(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXWH(paragraph2, n3);
    }

    final void zzXTf(Paragraph paragraph, int n) {
        this.zzXWH(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXkN().zzZTb() ? zzW0X.zzYjy(this.zzYXy, fieldName) : zzW0X.zzKW(this.zzXkN(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXWH(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXWH(field, isAfter, false);
    }

    private boolean zzXWH(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzq8 zzq82 = field.getFormat().zzYLS();
        Inline inline = zzq82.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXWH(inline.zzWky(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZ9O.zzXWH(this.zzYXy, bookmarkName) : zzZ9O.zzYhn(this.zzYXy, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzY52() == 6) {
            this.zzYhn((Paragraph)node.zzXjY(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzXEv.zzYUr(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzYhn(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXWH(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzX81(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXWH(cell, characterIndex);
    }

    private void zzYhn(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzY52() == 6) {
            this.zz5C(node);
        } else {
            Node node2 = node;
            if (zzXEv.zzWfD(node2.getNodeType())) {
                Paragraph paragraph = zzXEv.zzYUr(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zz5C(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzY52() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zz5C(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXww = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzWCC();
            return;
        }
        if (!this.zzzZ()) {
            this.zzWCC();
        }
    }

    private boolean zzzZ() {
        Node node = this.zzXkN();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzXkN(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXWH(inline.zzWky(), true);
            return true;
        }
        return false;
    }

    private void zzWCC() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXWH(documentBuilder.getCurrentParagraph().zzYcF(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzX81(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzWv6() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXkN().zzWv1(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zz44();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXWH(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzWX7(text, false);
    }

    public void writeln(String text) {
        this.zzWX7(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzXmj();
        Paragraph paragraph = this.getCurrentParagraph();
        zzWgw zzWgw2 = new zzWgw(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzYXy, this.zzZzO(), this.zz1l());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzYhn(this.zzXkN(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzWgw2.dispose();
        }
        if (this.getDocument().zzYS3()) {
            zzXEv.zzXTf((zzYry)paragraph, this.getDocument().zzXJJ());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzWdM() {
        zzWyY zzWyY2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzXmj();
        Node node = this.zzXkN();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzZ47(false);
        } else {
            run2 = run = (Run)node.zzY9c(21);
        }
        if (run2 == null && zzVs.zzYBf(node, paragraph.zzXpL())) {
            run = paragraph.zzXpL();
        }
        if (run != null) {
            cloneable = run.zzWky();
            zzWyY2 = (zzWyY)((zzOi)cloneable).zzW0c();
        } else {
            cloneable = paragraph.zzYcF();
            zzWyY2 = (zzWyY)((zzOi)cloneable).zzW0c();
        }
        zzWyY zzWyY3 = zzWyY2;
        Paragraph paragraph2 = new Paragraph(this.zzYXy, this.zzZzO(), zzWyY3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzWgw zzWgw2 = new zzWgw(this.zzYXy);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYhn(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzWgw2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXbf.zzYjy(this);
    }

    public void insertBreak(int breakType) {
        this.zzWw6(breakType, true);
    }

    final void zzWw6(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzYLq(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZae(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzZnv())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzYLq(bl)) {
                        this.zzZae(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzYLq(bl)) {
                        this.zzYKb(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzYLq(bl)) {
                        this.zzYKb(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzYLq(bl)) {
                        this.zzYKb(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzYLq(bl)) {
                        this.zzYKb(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzYLq(bl)) {
                        this.zzYKb(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZae(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzXJD.zzVPw(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzVX2.zzYhn("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzXmj();
        return zzXEv.zzXWH(fieldType, updateField, this.zz1l(), this.zzXkN(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzXmj();
        return zzXEv.zzXWH(fieldCode, this.zz1l(), this.zzXkN(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzXmj();
        return zzXEv.zzXWH(fieldCode, fieldValue, this.zz1l(), this.zzXkN(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzVs.zzYhn((Object)displayText, "displayText");
        zzVs.zzYhn((Object)urlOrBookmark, "hrefOrBookmark");
        zzZ3R zzZ3R2 = this.zzYhn(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZ3R2.zzYhn(documentBuilder.zzYUr(88, true));
        return zzXEv.zzXWH(zzZ3R2.getStart(), zzZ3R2.getSeparator(), zzZ3R2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWq0(70);
        if (zzXJD.zzVPw(name)) {
            this.startBookmark(name);
        }
        this.zzZuP(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzzA(70);
        String string = zzXJD.zzVPw(fieldValue) ? fieldValue : FormField.zzZiL;
        Run run = new Run(this.zzYXy, string, this.zz1l());
        this.insertNode(run);
        Node node = this.zzYUr(70, true);
        if (zzXJD.zzVPw(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXTP(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzYhn((Paragraph)node.zzXjY(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWq0(71);
        if (zzXJD.zzVPw(name)) {
            this.startBookmark(name);
        }
        this.zzZuP(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzYUr(71, false);
        if (zzXJD.zzVPw(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXTP(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWq0(83);
        if (zzXJD.zzVPw(name)) {
            this.startBookmark(name);
        }
        this.zzZuP(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzYUr(83, false);
        if (zzXJD.zzVPw(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXTP(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzYXy, footnoteType, !zzXJD.zzVPw(referenceMark), referenceMark, this.zz1l());
        Style style = this.getDocument().getStyles().zzZcu(zzXEv.zzYpg(footnoteType));
        footnote.zzWky().set(50, style.zzXHu());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzYXy);
        Style style2 = this.getDocument().getStyles().zzZcu(zzXEv.zzYfa(footnoteType));
        paragraph.zzZua().set(1000, style2.zzXHu());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzYXy, '\u0002', new zzWyY()) : new Run(this.zzYXy, footnote.getReferenceMark(), new zzWyY());
        inline.zzWky().set(50, style.zzXHu());
        paragraph.appendChild(inline);
        if (zzXJD.zzVPw(footnoteText)) {
            Node node = this.zzXkN();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zz5C(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzXnH(zzXGZ zzXGZ2) throws Exception {
        return this.zzXWH(zzXGZ2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzXnH(zzXGZ.zzYhn(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXWH(zzXGZ zzXGZ2, double d, double d2) throws Exception {
        return this.zzXWH(zzXGZ2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXWH(zzXGZ.zzYhn(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzVVw zzVVw2 = new zzVVw();){
            zzWD5.zzXWH(image, zzVVw2);
            Shape shape = this.zzXWH(zzVVw2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzVs.zzXWH(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYeG.zzYaX(fileName);
        try {
            Shape shape = this.zzXWH((zzXGZ)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXGZ)object).close();
            }
        }
    }

    private Shape zzXWH(zzXGZ zzXGZ2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXGZ2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzVs.zzYjy(zzXGZ2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXWH(zzXGZ.zzYhn(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXWH(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXWH(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzib.zzWrn(object)) {
            object4 = new zzWD5((byte[])object);
            bl2 = true;
            ((zzYRK)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzYXy.getCompatibilityOptions().getMswVersion() > 12 || this.zzYXy.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzYXy, 0);
            object3 = new zzD7();
            ((zzWiS)object3).zzXWH(zzWuX.zzZkK("rect"));
            ((zzD7)object3).zzXWH(new zzZVZ());
            ((zzD7)object3).zzWBL().zzWf6().zzX0q(this.zzYXy);
            object2 = new zzWo8();
            ((zzVZ0)object2).zzYhn(new zzZgh(this.zzYXy.zzZi6(), ""));
            ((zzVZ0)object2).zzXWH(new zzZGM());
            ((zzZs)object3).zzXWH((zzVZ0)object2);
            shape.zzXJV(75);
            shape.zzr1((zzZs)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzYXy, 75);
        }
        if (zzib.zzXNm(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXWH((byte[])object, new zzHm(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzHm(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzib.zzZmf((byte[])object2));
                this.zzXWH((zzD7)shape.zzZmU(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzD7)shape.zzZmU()).zzWBL().zzWf6().zzWZX((byte[])object);
            object3 = zzib.zzXKu(object);
            object4 = new zzHm(((zzX4x)object3).getWidthPoints(), ((zzX4x)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzXWH(this.zz1l());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzib.zzXHi(object)) {
            d5 = DocumentBuilder.zzXWH(shape, object);
        }
        shape.zzXWH(d3, d4, (zzHm)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXWH(Shape shape, byte[] byArray) throws Exception {
        int n = zzib.zzZ76(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzXEv.zzKL(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzXEv.zzXqf(n);
        return d;
    }

    private void zzXWH(zzD7 zzD72, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzD72.zzWBL().zzWf6().getExtensions();
        try (zzVVw zzVVw2 = new zzVVw(byArray);){
            object = zzXEv.zzXWH(zzVVw2, this.zzYXy);
            ((zzYVx)object).zzWMq(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzYVx)object).zzYfj();
            byArray2 = ((zzYVx)object).zzZuP(true);
        }
        zzD72.zzWBL().zzWf6().setExtensions(new zzLn<zzW4D>());
        object = zzW4D.zzXWH(byArray2, this.zzYXy);
        zzD72.zzWBL().zzWf6().getExtensions().zzYVD(((zzW4D)object).getUri(), (zzW4D)object);
    }

    private Shape zzXWH(zzXGZ zzXGZ2, String string, boolean bl, zzXGZ zzXGZ3) throws Exception {
        zzX8o zzX8o2 = zzX8o.zzX9M(string);
        Shape shape = this.zzXWH(zzXGZ3, bl, zzX8o2, null);
        zzXyD zzXyD2 = zzXio.zzXWH(zzXGZ2, string, bl);
        return DocumentBuilder.zzXWH(null, false, shape, zzX8o2.zzZJe, zzXyD2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXWH(zzXGZ.zzYhn(stream), progId, asIcon, zzXGZ.zzYhn(presentation));
    }

    private Shape zzXWH(String string, boolean bl, boolean bl2, zzXGZ zzXGZ2) throws Exception {
        zzX8o zzX8o2 = zzX8o.zzXUx(zzY7z.zzYC(string));
        return this.zzXWH(string, bl, bl2, zzXGZ2, zzX8o2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXWH(fileName, isLinked, asIcon, zzXGZ.zzYhn(presentation));
    }

    private Shape zzXWH(String string, String string2, boolean bl, boolean bl2, zzXGZ zzXGZ2) throws Exception {
        zzX8o zzX8o2 = zzX8o.zzX9M(string2);
        return this.zzXWH(string, bl, bl2, zzXGZ2, zzX8o2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXWH(fileName, progId, isLinked, asIcon, zzXGZ.zzYhn(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzX8o zzX8o2 = zzX8o.zzXUx(zzY7z.zzYC(fileName));
        return this.zzXWH(fileName, isLinked, iconFile, iconCaption, zzX8o2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzX8o zzX8o2 = zzX8o.zzX9M(progId);
        return this.zzXWH(fileName, isLinked, iconFile, iconCaption, zzX8o2);
    }

    private Shape zzXWH(zzXGZ zzXGZ2, String string, String string2, String string3) throws Exception {
        zzX8o zzX8o2 = zzX8o.zzX9M(string);
        Shape shape = this.zzXWH(string2, string3, zzX8o2);
        zzXyD zzXyD2 = zzXio.zzXWH(zzXGZ2, string, true);
        return DocumentBuilder.zzXWH(null, false, shape, zzX8o2.zzZJe, zzXyD2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzXWH(zzXGZ.zzYhn(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXWH(zz8x zz8x2, zzXGZ zzXGZ2) throws Exception {
        Shape shape = this.zzaH(zzXGZ2);
        shape.zzXJV(201);
        shape.getOleFormat().zzYhn(zz8x2.zzWdE());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzXmj();
        if (this.zzWrA()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzVWc(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzWp9 zzWp92 = zzXEv.zzXWH(html, options, this);
        zzWp92.zzZ9c();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzXmj();
        return zzXEv.zzXWH(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzXmj();
        return zzXEv.zzXWH(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZFa zzZFa2 = new zzZFa();
        return zzZFa2.zzXWH(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXQm(this).zzXWH(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXQm(this).zzXWH(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzYXy, 75);
        shape.zzXWH(this.zz1l());
        shape.zzZR3(true);
        shape.getSignatureLine().zzXWH(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXdH(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZeS(this.zzYXy);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzWrA() {
        boolean bl = false;
        if (this.zzXkN().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXkN().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzVWc(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzXmj();
        if (this.zzWv6() == null) {
            this.startTable();
        }
        if (this.zzWv6().zzYZh() == 1) {
            this.zzWv6().zzYgX();
        }
        if (this.zzWv6().zzYZh() == 3) {
            this.zzWv6().zzAT();
        }
        return this.zzWv6().zzWGS();
    }

    public Table startTable() {
        this.zzZ8z.push(new zzt5(this));
        return this.zzWv6().startTable();
    }

    public Table endTable() {
        if (this.zzWv6() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzWv6().endTable();
        this.zzZ8z.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzWv6() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzWv6().endRow();
        if (this.zzXkC != null && this.zzXkC.getHidden()) {
            row.zzWjO().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYXy, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYXy, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWVD();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYXy, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzWnF();
        bookmarkStart.zzYgC(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWVD();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzWnF();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYXy, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzWs3(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzYXy);
        this.zzX2w = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzX2w == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYXy, this.zzX2w);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYXy, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzVs.zzYhn((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXmj();
        return zzYU6.zzXWH(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzYXy;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzYXy) {
            return;
        }
        this.zzYXy = value;
        this.zz5C(null);
        this.zzZcy = new zzWyY();
        this.zzeD = null;
        this.zzZWC = null;
        this.zzXkC = null;
        this.zzZ8z = new zzX69();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzXkC == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXkC = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzXkC;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzXCm == null) {
            this.zzXCm = new RowFormat(this);
        }
        return this.zzXCm;
    }

    public CellFormat getCellFormat() {
        if (this.zzxi == null) {
            this.zzxi = new CellFormat(this);
        }
        return this.zzxi;
    }

    final void zzWrn(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzWyY zzWyY2 = this.getCurrentParagraph().zzYcF();
        this.zzWS9().push(new zzXWH(this.zz1l(), (zzWyY)zzWyY2.zzW0c()));
    }

    public void popFont() {
        zzX69<zzXWH> zzX692 = this.zzWS9();
        if (zzX692.size() > 0) {
            zzXWH zzXWH2 = (zzXWH)this.zzWS9().pop();
            this.zzXWH(zzXWH2.zzWky(), false);
            this.getCurrentParagraph().zzXxD(zzXWH2.zzYsh());
        }
    }

    final void zzYYv() {
        this.zzV().push(this.zz1l());
    }

    final void zzZTz() {
        zzX69<zzWyY> zzX692 = this.zzV();
        if (zzX692.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXWH((zzWyY)documentBuilder.zzV().pop(), false);
        }
    }

    final void zzYn0() {
        this.zzZtD().push(this.zzZzO());
    }

    final void zzYeD() {
        zzX69<zzWGb> zzX692 = this.zzZtD();
        if (zzX692.size() > 0) {
            this.getCurrentParagraph().zzXWH((zzWGb)this.zzZtD().pop());
        }
    }

    final zzZ3R zzYhn(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWq0(88);
        zzYpj zzYpj2 = new zzYpj();
        zzYpj2.setTarget(string2);
        zzYpj2.setScreenTip(string3);
        if (bl) {
            zzYpj2.setSubAddress(string);
        } else {
            zzYpj2.setAddress(zzW92.zz3L(string));
            zzYpj2.setSubAddress(zzW92.zzW94(string));
        }
        this.zzZuP(zzYpj2.zzWyv());
        FieldSeparator fieldSeparator = this.zzzA(88);
        return new zzZ3R(fieldStart, fieldSeparator, null);
    }

    final zzZ3R zzXeQ(String string, String string2, String string3) {
        boolean bl = zzW92.zzZRv(string);
        String string4 = bl ? zzW92.zzW94(string) : string;
        return this.zzYhn(string4, bl, string2, string3);
    }

    final FieldEnd zzWYP() {
        return this.zzYUr(88, true);
    }

    final zzWyY zz1l() {
        zzWyY zzWyY2 = this.zzZcy;
        return (zzWyY)zzWyY2.zzW0c();
    }

    final zzWGb zzZzO() {
        zzWGb zzWGb2 = this.getCurrentParagraph().zzZua();
        return (zzWGb)zzWGb2.zzW0c();
    }

    final zzZfM zzYVz() {
        zzZfM zzZfM2 = this.zzWjO();
        return (zzZfM)zzZfM2.zzW0c();
    }

    final zzW9z zzb0() {
        zzW9z zzW9z2 = this.zzJD();
        return (zzW9z)zzW9z2.zzW0c();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXkN(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXkN().getNodeType() == 8;
    }

    private void zzWX7(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzZGc.zzuQ(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXRY(string2.substring(n4, n4 + n2));
                }
                switch (this.zzVOt) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZae(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXRY(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzXmj();
        if (this.zzWv6() != null && this.zzWv6().zzYZh() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzXkN().getParentNode().insertBefore(node, this.zzXkN());
    }

    final void zzWti(int n) {
        this.zzYLq(true);
        this.zzYKb(n);
    }

    private void zzYKb(int n) {
        this.insertParagraph();
        zzWgw zzWgw2 = new zzWgw(this.getDocument());
        try {
            zzf4 zzf42 = this.getCurrentSection().zz0q();
            zzf4 zzf43 = (zzf4)zzf42.zzW0c();
            Section section = new Section(this.zzYXy, zzf43);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzYXy));
            this.zzYXy.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYhn(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzWgw2.dispose();
        }
    }

    final FieldStart zzWq0(int n) {
        this.zzXmj();
        return zzXEv.zzXWH(n, this.zz1l(), this.zzXkN(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzZuP(String string) {
        return zzXEv.zzYhn(string, this.zz1l(), this.zzXkN(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzYUr(int n, boolean bl) {
        return zzXEv.zzYhn(n, bl, this.zz1l(), this.zzXkN(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzzA(int n) {
        return zzXEv.zzYhn(n, this.zz1l(), this.zzXkN(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzXTP(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzYXy, new zzYBZ(), this.zz1l());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzYLq(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzWv6() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzX81(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXRY(String string) {
        if (this.zzYlL(string)) {
            zzZIw zzZIw2 = new zzZIw(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYZX zzYZX2 : zzZIw2.zzYto(this.getParagraphFormat().getBidi())) {
                zzWX7 zzWX72 = zzWX7.zzwi(zzYZX2.zzWvG());
                zzWyY zzWyY2 = this.zz1l();
                zzWyY2.zzXeQ(265, zzWX72);
                if (zzYZX2.zzWH6()) {
                    zzWyY2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzYXy, zzYZX2.getText(), zzWyY2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZae(string);
    }

    private boolean zzYlL(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYYS.zzWks(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXWH(zzWyY zzWyY2, boolean bl) {
        zzWyY zzWyY3;
        if (bl) {
            zzWyY zzWyY4 = zzWyY2;
            zzWyY3 = (zzWyY)zzWyY4.zzW0c();
        } else {
            zzWyY3 = zzWyY2;
        }
        this.zzZcy = zzWyY3;
    }

    final void zzZ2V() {
        this.zzZcy.clear();
    }

    final void zzY5m() {
        if (this.zzWVD() != null) {
            zzW9z zzW9z2;
            zzW9z zzW9z3 = zzW9z2 = this.zzWVD().zzJD();
            this.zzVI = (zzW9z)zzW9z3.zzW0c();
            zzW9z2.zzYhn(this.zzVI);
        }
    }

    private Shape zzXWH(String string, boolean bl, boolean bl2, zzXGZ zzXGZ2, zzX8o zzX8o2) throws Exception {
        if (zzX8o2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzXWH(zzXGZ2, bl2, zzX8o2, string);
        zzXyD zzXyD2 = zzXio.zzXWH(string, bl, bl2, zzX8o2);
        return DocumentBuilder.zzXWH(string, bl, shape, zzX8o2.zzZJe, zzXyD2);
    }

    private Shape zzXWH(String string, boolean bl, String string2, String string3, zzX8o zzX8o2) throws Exception {
        if (zzX8o2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzY7z.zzZ2y(string);
        }
        Shape shape = string2 != null ? this.zzXLf(string2, string3) : this.zzXWH(null, string3, zzX8o2);
        zzXyD zzXyD2 = zzXio.zzXWH(string, bl, true, zzX8o2);
        return DocumentBuilder.zzXWH(string, bl, shape, zzX8o2.zzZJe, zzXyD2);
    }

    private static Shape zzXWH(String string, boolean bl, Shape shape, String string2, zzXyD zzXyD2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzXJV(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYhn(zzXyD2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXWH(zzXGZ zzXGZ2, boolean bl, zzX8o zzX8o2, String string) throws Exception {
        if (zzX8o2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzXGZ2 != null) {
            return this.zzaH(zzXGZ2);
        }
        if (!bl) {
            return this.zzXiW(zzXio.zzXlU().get("normal"));
        }
        String string2 = string != null ? zzY7z.zzZ2y(string) : zzXio.zzY8F(zzX8o2.zzHJ);
        return this.zzXWH(zzX8o2, string2);
    }

    private Shape zzXWH(String string, String string2, zzX8o zzX8o2) throws Exception {
        if (zzX8o2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzXio.zzY8F(zzX8o2.zzHJ);
        }
        if (string != null) {
            return this.zzXLf(string, string2);
        }
        return this.zzXWH(zzX8o2, string2);
    }

    private Shape zzXWH(zzX8o zzX8o2, String string) throws Exception {
        if (zzX8o2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzXio.zzZhb(zzX8o2.zzHJ);
        zzXjE zzXjE2 = new zzXjE(byArray, null, string, this.getDocument().zzWO2());
        return this.zzXiW(zzXjE2.zz8g());
    }

    private Shape zzXLf(String string, String string2) throws Exception {
        zzXjE zzXjE2 = new zzXjE(string, string2, this.getDocument().zzWO2());
        return this.zzXiW(zzXjE2.zz8g());
    }

    private Shape zzaH(zzXGZ zzXGZ2) throws Exception {
        byte[] byArray = zzVs.zzYjy(zzXGZ2);
        return this.zzXiW(byArray);
    }

    private Shape zzXiW(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzYXy, 1);
        shape.zzXJV(75);
        shape.zzXWH(this.zz1l());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXdH(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXWH(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYhn(compositeNode, n);
            return;
        }
        this.zzXTf(compositeNode, n);
    }

    private void zzYhn(CompositeNode compositeNode, int n) {
        zzsV zzsV2 = zzsV.zzYsl(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzsV2.zzXWH(null, true, true, true, false, true);
            node = zzsV2.getNode();
            if (zzsV2.zzWfk() && (!node.isComposite() || node.zzY52() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzZbn().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzYhn(null, node);
            this.zzXww = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXTf(CompositeNode compositeNode, int n) {
        zzsV zzsV2 = zzsV.zzWBl(compositeNode);
        while (zzsV2.getNode() != compositeNode || !zzsV2.zzWfk()) {
            int n2;
            Node node = zzsV2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZbn().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzYhn(null, node);
                this.zzXww = n;
                return;
            }
            while (zzsV2.zzXWH(null, false, true, true, false, true) && zzsV2.zzWfk() && zzsV2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzXmj() {
        int n = this.zzXww;
        if (n == 0) {
            return;
        }
        this.zzXww = 0;
        Run run = zzVs.zzXWH((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWRj(n);
        }
    }

    private Run zzZae(String string) {
        Run run = new Run(this.zzYXy, string, this.zz1l());
        this.insertNode(run);
        return run;
    }

    final boolean zzWhb() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzWPD() {
        return this.zzVOt;
    }

    final void zzWfy(int n) {
        this.zzVOt = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzXkN();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXkN();
        }
        return (Paragraph)this.zzXkN().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzt5 zzWv6() {
        zzX69<zzt5> zzX692 = this.zzZ8z;
        if (zzX692.size() > 0) {
            return (zzt5)this.zzZ8z.peek();
        }
        return null;
    }

    private Cell zzWVD() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZdy();
    }

    private zzX69<zzWyY> zzV() {
        if (this.zzeD == null) {
            this.zzeD = new zzX69();
        }
        return this.zzeD;
    }

    private zzX69<zzWGb> zzZtD() {
        if (this.zzZWC == null) {
            this.zzZWC = new zzX69();
        }
        return this.zzZWC;
    }

    private zzX69<zzXWH> zzWS9() {
        if (this.zzW7Y == null) {
            this.zzW7Y = new zzX69();
        }
        return this.zzW7Y;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZcy.zzWN6(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzj0(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzj0(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZcy.zzXeQ(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzX1C()) {
            this.getCurrentParagraph().zzYcF().zzXeQ(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZcy.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZcy.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzX1C()) {
            this.getCurrentParagraph().zzYcF().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWjO().zzWN6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWjO().zzWKF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWjO().zzZ1n(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWjO().zzXeQ(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWjO().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWjO().clear();
        zzZfM.zzXbg().zzYhn(this.zzWjO());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzJD().zzWN6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzJD().zzWKF(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzJD().zzZ1n(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzVs.zzXWH(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWVD() != null ? this.zzWVD().getCellFormat() : this.getCellFormat();
            border.zzXWH(cellFormat);
        }
        this.zzJD().zzXeQ(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzJD().clear();
    }

    private Node zzXkN() {
        Node node = this.zzY0L != null && this.zzY0L.getParentNode() == null ? this.zzWpR : this.zzY0L;
        if (node != null && node.zzY52() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zz5C(Node node) {
        this.zzY0L = node;
        if (this.zzY0L != null) {
            this.zzWpR = this.zzY0L.getParentNode();
        }
    }

    private zzZfM zzWjO() {
        if (this.zzWv6() != null && this.zzWv6().zzYZh() == 1) {
            return this.zzWU5;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWjO();
        }
        return this.zzWU5;
    }

    private zzW9z zzJD() {
        if (this.zzWv6() != null && this.zzWv6().zzYZh() != 3) {
            return this.zzVI;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZdy().zzJD();
        }
        return this.zzVI;
    }

    static final class zzXWH {
        private zzWyY zzZcy;
        private zzWyY zzW2a;

        public zzXWH(zzWyY zzWyY2, zzWyY zzWyY3) {
            this.zzZcy = zzWyY2;
            this.zzW2a = zzWyY3;
        }

        public final zzWyY zzWky() {
            return this.zzZcy;
        }

        public final zzWyY zzYsh() {
            return this.zzW2a;
        }
    }
}

