/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzVVE;
import com.aspose.words.internal.zzVVw;
import com.aspose.words.internal.zzVX2;
import com.aspose.words.internal.zzVs;
import com.aspose.words.internal.zzWxg;
import com.aspose.words.internal.zzX1g;
import com.aspose.words.internal.zzX9i;
import com.aspose.words.internal.zzXAG;
import com.aspose.words.internal.zzXGZ;
import com.aspose.words.internal.zzXRU;
import com.aspose.words.internal.zzYwA;
import com.aspose.words.internal.zzkY;
import com.aspose.words.zzVSu;
import com.aspose.words.zzWUs;
import com.aspose.words.zzWg6;
import com.aspose.words.zzWwn;
import com.aspose.words.zzX1s;
import com.aspose.words.zzXAq;
import com.aspose.words.zzXZQ;
import com.aspose.words.zzXip;
import com.aspose.words.zzZ0B;
import com.aspose.words.zzaj;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXWH(zzXGZ zzXGZ2, zzXGZ zzXGZ3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzVs.zzYhn((Object)zzXGZ2, "srcStream");
        zzVs.zzYhn((Object)zzXGZ3, "dstStream");
        zzVs.zzYhn((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYhn(zzXGZ2, zzXGZ3, certificateHolder, signOptions);
        zzXGZ3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXWH(zzXGZ.zzYhn(srcStream), (zzXGZ)zzXGZ.zzXTf(dstStream), certHolder, signOptions);
    }

    private static void zzYhn(zzXGZ zzXGZ2, zzXGZ zzXGZ3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzXTf(digitalSignature);
        }
        if (zzZ0B.zzXLf(zzXGZ2)) {
            DigitalSignatureUtil.zzXWH(zzXGZ2, zzXGZ3, digitalSignature, true);
            return;
        }
        zzZ0B zzZ0B2 = new zzZ0B();
        zzXGZ zzXGZ4 = zzXGZ2;
        zzZ0B zzZ0B3 = zzZ0B2;
        FileFormatInfo fileFormatInfo = zzZ0B2.zzYhn(zzXGZ4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXAG zzXAG2 = new zzXAG(zzXGZ2);
                int n = fileFormatInfo.zzZfR() == 1 ? 1 : 2;
                zzVSu.zzXWH(zzXAG2, digitalSignature, n);
                zzXGZ3.zzZnw(0L);
                zzXAG2.zzZv8(zzXGZ3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXWH(fileFormatInfo.zz1a(), zzXGZ3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXWH(zzXGZ2, zzXGZ3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXWH(zzXGZ2, zzXGZ3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzVs.zzXWH(srcFileName, "srcFileName");
        zzVs.zzXWH(dstFileName, "dstFileName");
        try (zzkY zzkY2 = zzVs.zzYhn(srcFileName, 3, 1);){
            try (zzkY zzkY3 = zzVs.zzYhn(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXWH((zzXGZ)zzkY2, (zzXGZ)zzkY3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzX9i zzX9i2 = zzXGZ.zzXTf(dstStream);
        zzXGZ zzXGZ2 = zzXGZ.zzYhn(srcStream);
        DigitalSignatureUtil.zzXWH(zzXGZ2, (zzXGZ)zzX9i2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzkY zzkY2 = zzVs.zzYhn(srcFileName, 3, 1);){
            try (zzkY zzkY3 = zzVs.zzYhn(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzX0q(zzkY2, zzkY3);
            }
            return;
        }
    }

    private static void zzX0q(zzXGZ zzXGZ2, zzXGZ zzXGZ3) throws Exception {
        zzZ0B zzZ0B2 = new zzZ0B();
        zzXGZ zzXGZ4 = zzXGZ2;
        zzZ0B zzZ0B3 = zzZ0B2;
        FileFormatInfo fileFormatInfo = zzZ0B2.zzYhn(zzXGZ4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXAG zzXAG2 = new zzXAG(zzXGZ2);
                zzXAG2.zzI3().zzYHI("_xmlsignatures");
                zzXAG2.zzI3().zzYHI("_signatures");
                zzXGZ3.zzYMr(0L);
                zzXAG2.zzZv8(zzXGZ3);
                zzXGZ zzXGZ5 = zzXGZ3;
                zzXGZ5.zzZnw(zzXGZ5.zzX8N());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYwA zzYwA2 = new zzYwA(zzXGZ2);
                zzWxg zzWxg2 = zzYwA2.zzXWH(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzWxg2 != null) {
                    for (zzX1g zzX1g2 : zzWxg2.zzWWG()) {
                        String string = zzWxg2.zzXWH(zzX1g2);
                        zzYwA2.zzY4Y().remove(string);
                    }
                    zzYwA2.zzY4Y().remove(zzWxg2.getName());
                    zzX1g zzX1g3 = zzYwA2.zzWWG().zzYRv("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYwA2.zzWWG().remove(zzX1g3.getId());
                    zzYwA2.zzYQg();
                }
                zzXGZ3.zzYMr(0L);
                zzYwA2.zzZv8(zzXGZ3);
                zzXGZ zzXGZ6 = zzXGZ3;
                zzXGZ6.zzZnw(zzXGZ6.zzX8N());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzX0q(zzXGZ.zzYhn(srcStream), zzXGZ.zzXTf(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzkY zzkY2 = zzVs.zzYhn(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zz5C(zzkY2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zz5C(zzXGZ zzXGZ2) throws Exception {
        if (zzZ0B.zzXLf(zzXGZ2)) {
            return DigitalSignatureUtil.zzZDq(zzXGZ2);
        }
        zzZ0B zzZ0B2 = new zzZ0B();
        zzXGZ zzXGZ3 = zzXGZ2;
        zzZ0B zzZ0B3 = zzZ0B2;
        FileFormatInfo fileFormatInfo = zzZ0B2.zzYhn(zzXGZ3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXGZ2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zz5C(zzXGZ.zzYhn(stream));
    }

    static zzVVw zzXWH(zzXAG zzXAG2, String string) throws Exception {
        zzXZQ zzXZQ2 = new zzXZQ(zzXAG2);
        if (zzXZQ2.zzEw()) {
            zzVVw zzVVw2 = zzXZQ2.zzWs2(string);
            return zzVVw2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZxV(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzVX2.zzYhn("Unexpected digest algorithm: {0}.", n));
    }

    static String zzXlW(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZxV(n);
    }

    private static void zzXWH(zzXGZ zzXGZ2, zzXGZ zzXGZ3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYwA zzYwA2 = new zzYwA(zzXGZ2);
        zzaj zzaj2 = bl ? new zzXAq(zzYwA2) : new zzWg6(zzYwA2);
        zzaj2.zzYhn(digitalSignature);
        zzXGZ3.zzZnw(0L);
        zzYwA2.zzZv8(zzXGZ3);
    }

    private static void zzXWH(zzXGZ zzXGZ2, zzXGZ zzXGZ3, DigitalSignature digitalSignature) throws Exception {
        zzWUs zzWUs2 = new zzWUs(zzXGZ2);
        zzXip zzXip2 = new zzXip(zzWUs2);
        zzXip2.zzYhn(digitalSignature);
        zzXGZ3.zzZnw(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXGZ zzXGZ4 = zzXGZ3;
        zzWUs zzWUs3 = zzWUs2;
        zzWUs3.zzXWH(zzXGZ4, string, null);
    }

    private static void zzXWH(zzXAG zzXAG2, zzXGZ zzXGZ2, DigitalSignature digitalSignature, String string) throws Exception {
        zzVVw zzVVw2 = DigitalSignatureUtil.zzXWH(zzXAG2, string);
        zzVVw zzVVw3 = new zzVVw();
        DigitalSignatureUtil.zzXWH((zzXGZ)zzVVw2, (zzXGZ)zzVVw3, digitalSignature, false);
        zzXAG zzXAG3 = zzXZQ.zzXTf(zzVVw3, string);
        zzXAG3.zzZv8(zzXGZ2);
    }

    private static DigitalSignatureCollection zzZDq(zzXGZ zzXGZ2) throws Exception {
        zzXGZ2.zzYMr(0L);
        zzYwA zzYwA2 = new zzYwA(zzXGZ2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzWxg zzWxg2 = zzYwA2.zzXWH(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzWxg2 != null) {
            for (zzX1g zzX1g2 : zzWxg2.zzWWG()) {
                String string = zzWxg2.zzXWH(zzX1g2);
                zzWxg zzWxg3 = zzYwA2.zzWv1(string);
                zzWxg zzWxg4 = zzYwA2.zzXWH(zzWxg3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzVVE zzVVE2 = zzXRU.zzZ1S(zzWxg4.zzZ7U().zzWCg());
                zzX1s.zzXWH(zzWxg3.zzZWS(), zzVVE2, new zzWwn(zzYwA2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

