/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzVs;
import com.aspose.words.zzVWS;
import com.aspose.words.zzWgw;
import com.aspose.words.zzWnA;
import com.aspose.words.zzXEv;
import com.aspose.words.zzXxQ;
import com.aspose.words.zzYJq;
import com.aspose.words.zzYYS;
import com.aspose.words.zzZsK;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZsK,
Iterable<T> {
    private Node zzZ1M;
    private Node zzZ5C;
    private Node zzZlX;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzYhn((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzYq2() {
        return this.zzYIs() != null;
    }

    final boolean zzVVF() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZcZ() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzWnA) {
                return true;
            }
            CompositeNode compositeNode = zzVs.zzXWH((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZcZ()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZ1M;
    }

    public Node getLastChild() {
        return this.zzZ5C;
    }

    final Node zzYIs() {
        return zzXEv.zzKW(this.getFirstChild(), false);
    }

    final Node zzWbU() {
        return zzXEv.zzZvG(this.getLastChild(), false);
    }

    final CompositeNode zzYnK() {
        return (CompositeNode)zzXEv.zzKW(this.getFirstChild(), true);
    }

    final CompositeNode zzWM3() {
        return (CompositeNode)zzXEv.zzZvG(this.getLastChild(), true);
    }

    final Node zzZpZ() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzXEv.zzWfD((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zz63() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzXEv.zzWfD((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXWH(boolean bl, zzYJq zzYJq2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXWH(bl, zzYJq2);
        ((CompositeNode)super.zzXWH(bl, zzYJq2)).zzZ5C = null;
        compositeNode.zzZ1M = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZaS(node.zzXWH(true, zzYJq2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZv8(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZv8(StringBuilder stringBuilder) {
        this.zzYBf(stringBuilder);
        zzVs.zzYhn(stringBuilder, this.zzZbn());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYhn(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXEv.zzYCD(nodeType);
            Node node2 = node = bl ? this.zzYIs() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZ8N() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzYYS.zzXTf(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzYYS.zzX0q(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXxQ(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXWH(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXWH(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzYhn(oldChild, false);
    }

    private Node zzYhn(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXWH(node, (Node)this, null, 1);
        if (documentBase.zzYS3() && zzXEv.zzYHI(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXWH(nodeChangingArgs);
        }
        if (!bl && zzXEv.zzYEl(node)) {
            zzXEv.zzYTK(node, false);
        }
        Node node2 = this.zzZxT(node);
        if (nodeChangingArgs != null) {
            documentBase.zzYhn(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzVWS.zzYMr(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZaS(Node node) {
        node.getParentNode();
        if (this.zzZ5C == null) {
            node.zzRu(null);
            node.zzZuv(null);
            this.zzZ1M = node;
        } else {
            node.zzRu(this.zzZ5C);
            node.zzZuv(null);
            this.zzZ5C.zzZuv(node);
        }
        this.zzZ5C = node;
        node.zzXDS(this);
        return node;
    }

    final void zzXWH(Node node, Node node2, Node node3) {
        this.zzXWH(node, node2, node3, false);
    }

    final void zzXWH(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzYjy(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYhn(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXTf(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzXEv.zzWfD(node3.getNodeType())) continue;
            if (zzXEv.zzYVD(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZbn().length();
    }

    String zzZbn() {
        return "";
    }

    final String zzWM1() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYBf(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzYBf(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZv8(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXWH(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzYhn(visitor));
    }

    abstract int zzXWH(DocumentVisitor var1) throws Exception;

    abstract int zzYhn(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzYjy(Node var1);

    final Node zzXWH(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzWv1(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzYjy(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzWgw(documentBase);
            try {
                compositeNode.zzYhn(node, true);
            }
            finally {
                ((zzWgw)object).dispose();
            }
        }
        if ((object = documentBase.zzXWH(node, null, (Node)this, 0)) != null) {
            documentBase.zzXWH((NodeChangingArgs)object);
        }
        if (this.zzZ5C == null) {
            node.zzRu(null);
            node.zzZuv(null);
            this.zzZ1M = node;
            this.zzZ5C = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzYhn(node, node2);
            } else {
                this.zzXTf(node, this.zzZ1M);
            }
        } else if (node2 != null) {
            this.zzXTf(node, node2);
        } else {
            this.zzYhn(node, this.zzZ5C);
        }
        node.zzXDS(this);
        if (object != null) {
            documentBase.zzYhn((NodeChangingArgs)object);
        }
        if (documentBase.zzYS3()) {
            zzXEv.zzXWH(node, compositeNode, node3);
        }
        return node;
    }

    private void zzYhn(Node node, Node node2) {
        Node node3 = node2.zzWq3();
        node.zzRu(node2);
        node.zzZuv(node3);
        node2.zzZuv(node);
        if (node3 == null) {
            this.zzZ5C = node;
            return;
        }
        node3.zzRu(node);
    }

    private void zzXTf(Node node, Node node2) {
        Node node3 = node2.zzy5();
        node.zzRu(node3);
        node.zzZuv(node2);
        node2.zzRu(node);
        if (node3 == null) {
            this.zzZ1M = node;
            return;
        }
        node3.zzZuv(node);
    }

    private Node zzZxT(Node node) {
        if (node == this.zzZ1M) {
            if (this.zzZ1M == this.zzZ5C) {
                this.zzZ1M = null;
                this.zzZ5C = null;
            } else {
                this.zzZ1M = node.zzWq3();
                this.zzZ1M.zzRu(null);
            }
        } else {
            Node node2 = node.zzy5();
            Node node3 = node.zzWq3();
            node2.zzZuv(node3);
            if (node3 == null) {
                this.zzZ5C = node2;
            } else {
                node3.zzRu(node2);
            }
        }
        node.zzZuv(null);
        node.zzRu(null);
        node.zzXDS(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZlX = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZlX;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

