/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzVs;
import com.aspose.words.internal.zzZrw;
import com.aspose.words.zzLn;
import com.aspose.words.zzVX;
import com.aspose.words.zzWKY;
import com.aspose.words.zzWYa;
import com.aspose.words.zzX1M;
import com.aspose.words.zzXB1;
import com.aspose.words.zzXsb;
import com.aspose.words.zzYkC;
import com.aspose.words.zzYnh;
import com.aspose.words.zzZ4t;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYnh zzY34;

    ChartSeriesCollection(zzYnh dmlChart) {
        this.zzY34 = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY34.zzDo().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY34.zzDo().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzY34.zzDo().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzY34.zzDo().clear();
        this.zzWv1(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXWH(seriesName, values);
        chartSeries.zzZEE().zzX0q(ChartSeriesCollection.zzYBf(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXWH(seriesName, yValues);
        chartSeries.zzZEE().zzX0q(ChartSeriesCollection.zzX0q(xValues));
        return chartSeries;
    }

    private ChartSeries zzXWH(String string, zzZrw[] zzZrwArray, double[] dArray) {
        if (zzZrwArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzZrwArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzZrwArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXWH(string, dArray);
        chartSeries.zzZEE().zzX0q(ChartSeriesCollection.zzXWH(zzZrwArray));
        if (!this.zzY34.zzZS5()) {
            this.zzWv1(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXWH(seriesName, zzZrw.zzXWH(dates), values);
    }

    private void zzWv1(boolean bl) {
        zzX1M zzX1M2 = zzVs.zzXWH((Object)this.zzY34, zzX1M.class);
        if (zzX1M2 != null && zzX1M2.zzWvZ().zzYN9()) {
            zzX1M2.zzWvZ().zzW9l().zzxn(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzY34.zzWif() != 15) {
            this.zzY34.zzZUB(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXWH(seriesName, yValues);
        chartSeries.zzZS0().zzXn8().zzxn(3, this.zzY34.zzZ6T());
        chartSeries.zzZEE().zzX0q(ChartSeriesCollection.zzX0q(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzX2c().zzX0q(ChartSeriesCollection.zzX0q(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzXWH(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzY34);
        chartSeries.setName(string);
        this.zzYjy(chartSeries);
        chartSeries.zzZD3(this.zzY34.zza8().zzXd1() + 1);
        chartSeries.zzXbc(this.zzY34.zza8().zzd8() + 1);
        chartSeries.zz3d().zzX0q(ChartSeriesCollection.zzX0q(dArray));
        this.zzY34.zzIa().zzXAM();
        this.zzY34.zzXLH(chartSeries);
        return chartSeries;
    }

    private void zzYjy(ChartSeries chartSeries) {
        chartSeries.zzZS0().zzXn8().zzxn(5, new zzXB1());
        switch (this.zzY34.zzWif()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXWH(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXWH(chartSeries, 5);
                ChartSeriesCollection.zzZvG(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXWH(chartSeries, 1);
                ChartSeriesCollection.zzZvG(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzKW(chartSeries);
            }
        }
    }

    private static void zzKW(ChartSeries chartSeries) {
        zzXB1 zzXB12 = new zzXB1();
        zzXB12.setOutline(new zzXsb());
        zzYkC zzYkC2 = new zzYkC();
        zzYkC2.zzMA(1);
        zzXB12.getOutline().setFill(new zzLn(zzYkC2));
        zzXB12.getOutline().zzXop(19050.0);
        chartSeries.zzZS0().zzXn8().zzxn(5, zzXB12);
    }

    private static void zzZvG(ChartSeries chartSeries) {
        zzXB1 zzXB12 = new zzXB1();
        zzXB12.setOutline(new zzXsb());
        zzXB12.getOutline().setFill(new zzZ4t());
        zzXB12.getOutline().setEndCap(0);
        zzXB12.getOutline().zzXop(19050.0);
        chartSeries.zzZS0().zzXn8().zzxn(5, zzXB12);
    }

    private static void zzXWH(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzXok());
        chartMarker.zzZPY().zzxn(0, n);
        chartSeries.zzZS0().zzXn8().zzxn(4, chartMarker);
    }

    private static zzWYa zzX0q(double[] dArray) {
        int n = 0;
        zzWYa zzWYa2 = new zzWYa(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzWYa2.zzYjy(new zzWKY(n, d, "General"));
            }
            ++n;
        }
        zzWYa2.zzZA4(dArray.length);
        return zzWYa2;
    }

    private static zzWYa zzXWH(zzZrw[] zzZrwArray) {
        int n = 0;
        zzWYa zzWYa2 = new zzWYa(2);
        zzZrw[] zzZrwArray2 = zzZrwArray;
        int n2 = zzZrwArray.length;
        for (int i = 0; i < n2; ++i) {
            zzZrw zzZrw2 = zzZrwArray2[i];
            zzWYa2.zzYjy(new zzWKY(n++, zzZrw2.zzWeM(), "m/d/yyyy"));
        }
        zzWYa2.zzZA4(zzZrwArray.length);
        return zzWYa2;
    }

    private static zzWYa zzYBf(String[] stringArray) {
        int n = 0;
        zzWYa zzWYa2 = new zzWYa(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzWYa2.zzYjy(new zzVX(n++, string));
        }
        zzWYa2.zzZA4(stringArray.length);
        return zzWYa2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY34.zzDo().size();
    }
}

