/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzVs;
import com.aspose.words.zz5V;
import com.aspose.words.zzOi;
import com.aspose.words.zzW9z;
import com.aspose.words.zzXEv;
import com.aspose.words.zzXUW;
import com.aspose.words.zzYJq;
import com.aspose.words.zzYZX;
import com.aspose.words.zzYog;
import com.aspose.words.zzYry;
import com.aspose.words.zzZGc;

public class Cell
extends CompositeNode<Node>
implements zzXUW,
zzYry {
    private zzW9z zzVI;
    private CellFormat zzxi;
    private ParagraphCollection zzZXV;
    private TableCollection zzs3;

    public Cell(DocumentBase doc) {
        this(doc, new zzW9z());
    }

    Cell(DocumentBase doc, zzW9z cellPr) {
        super(doc);
        this.zzVI = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzZnn() {
        return (Cell)this.zz44();
    }

    public Row getParentRow() {
        return (Row)this.zzXjY();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzWPv() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzXTf(this, true);
        }
        return -1;
    }

    final int zzWgt() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzWgt();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzxi == null) {
            this.zzxi = new CellFormat(this);
        }
        return this.zzxi;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzZXV == null) {
            this.zzZXV = new ParagraphCollection(this);
        }
        return this.zzZXV;
    }

    public TableCollection getTables() {
        if (this.zzs3 == null) {
            this.zzs3 = new TableCollection(this);
        }
        return this.zzs3;
    }

    final zzW9z zzJD() {
        return this.zzVI;
    }

    final void zzXWH(zzW9z zzW9z2) {
        this.zzVI = zzW9z2;
    }

    @Override
    final Node zzXWH(boolean bl, zzYJq zzYJq2) {
        zzW9z zzW9z2;
        Cell cell = (Cell)super.zzXWH(bl, zzYJq2);
        zzW9z zzW9z3 = this.zzVI;
        cell.zzVI = zzW9z2 = (zzW9z)zzW9z3.zzW0c();
        cell.zzxi = null;
        cell.zzZXV = null;
        cell.zzs3 = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXWH(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzYhn(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZGc.zzWYs(this);
    }

    @Override
    final boolean zzYjy(Node node) {
        return zzXEv.zzWMq(node);
    }

    final int zzWnF() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zz44();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzVI.zzWN6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzVI.zzWN6(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzYog zzYog2 = zzVs.zzXWH(object, zzYog.class);
        if (zzYog2 != null && zzYog2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzWCD(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzW9z.zzYR2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzVI.zzXeQ(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzVI.clear();
    }

    private Object zzWCD(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzVs.zzXWH((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXWH(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYZX getInsertRevision() {
        Cell cell = this;
        return cell.zzVI.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzYZX value) {
        Cloneable cloneable = this;
        zzYZX zzYZX2 = value;
        cloneable = cloneable.zzVI;
        ((zzOi)cloneable).zzXeQ(14, zzYZX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYZX getDeleteRevision() {
        Cell cell = this;
        return cell.zzVI.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzYZX value) {
        Cloneable cloneable = this;
        zzYZX zzYZX2 = value;
        cloneable = cloneable.zzVI;
        ((zzOi)cloneable).zzXeQ(12, zzYZX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz5V getMoveFromRevision() {
        Cell cell = this;
        return cell.zzVI.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zz5V value) {
        Cloneable cloneable = this;
        zz5V zz5V2 = value;
        cloneable = cloneable.zzVI;
        ((zzOi)cloneable).zzXeQ(13, zz5V2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz5V getMoveToRevision() {
        Cell cell = this;
        return cell.zzVI.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zz5V value) {
        Cloneable cloneable = this;
        zz5V zz5V2 = value;
        cloneable = cloneable.zzVI;
        ((zzOi)cloneable).zzXeQ(15, zz5V2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzVI.remove(13);
        cell = this;
        cell.zzVI.remove(15);
    }

    final zzW9z zzfk(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzW9z zzW9z2 = new zzW9z();
        this.zzXWH(3120, zzW9z2);
        this.zzXWH(3140, zzW9z2);
        this.zzXWH(3110, zzW9z2);
        this.zzXWH(3130, zzW9z2);
        this.zzXWH(3090, zzW9z2);
        this.zzXWH(3100, zzW9z2);
        this.zzXWH(3070, zzW9z2);
        this.zzXWH(3080, zzW9z2);
        if (bl && (tableStyle = zzVs.zzXWH((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYhn(this, zzW9z2);
        }
        this.zzVI.zzYhn((zzOi)zzW9z2);
        return zzW9z2;
    }

    private void zzXWH(int n, zzW9z zzW9z2) {
        zzW9z2.zzXeQ(n, this.fetchInheritedCellAttr(n));
    }
}

