/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzYqK;
import com.aspose.words.zz53;
import com.aspose.words.zzW3K;
import com.aspose.words.zzZP3;
import com.aspose.words.zzZT1;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzW3K,
Iterable<T> {
    private Node zzWvZ;
    private CompositeNode zzZeu;
    private DocumentBase zzY5U;
    private boolean zzYgx;
    private int zzWHc;
    private int zzX5c;
    private Node zzqH;
    private int zzYYM;
    private zz53 zzZ1Y;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzZP3.zzXFa(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZP3(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zz53 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzZeu = container;
        this.zzY5U = container.getDocument();
        this.zzZ1Y = matcher;
        this.zzYgx = isDeep;
        this.zzYCT();
    }

    public Node get(int index) {
        try {
            this.zzWr5();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzX5c == index) {
                return this.zzqH;
            }
            int n = index - this.zzX5c;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzX7v(nodeCollection.zzqH, n);
            if (node != null) {
                this.zzX5c = index;
                this.zzqH = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYgx) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZeu.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYgx) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZeu.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzWhA();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZT1(this);
    }

    final <TNode extends Node> zzZT1<TNode> zzXS7() {
        return new zzZT1(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzWhA() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzYqK.zzab(arrayList, node);
        }
        return arrayList;
    }

    private Node zzX7v(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzLA(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzXvs(curNode, true);
    }

    private Node zzXvs(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzWvZ = node;
        do {
            node2 = this.zzWvZ;
            Node node3 = this.zzYgx ? this.zzab(true, this.zzWvZ) : (this.zzWvZ = this.zzZ1Y.zzYIM() ? this.zzzD(true, this.zzWvZ) : this.zzYCO(true, this.zzWvZ));
        } while (this.zzWvZ != null && !this.zzZ1Y.zzX7v(this.zzWvZ));
        return node2;
    }

    private Node zzLA(Node node, boolean bl) throws Exception {
        while ((this.zzYgx ? this.zzab(bl, node) : (node = this.zzZ1Y.zzYIM() ? this.zzzD(bl, node) : this.zzYCO(bl, node))) != null && !this.zzZ1Y.zzX7v(node)) {
        }
        return node;
    }

    private Node zzab(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZeu);
        }
        return node.previousPreOrder(this.zzZeu);
    }

    private Node zzYCO(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZeu) {
                return this.zzZeu.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZeu) {
            return this.zzZeu.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzzD(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZeu ? this.zzZeu.zzMP() : node.zzXbi();
        } else {
            Node node3 = node2 = node == this.zzZeu ? this.zzZeu.zzJw() : node.zzYaq();
        }
        if (node2 == this.zzZeu.getNextSibling() || node2 == this.zzZeu.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzWr5() {
        if (this.zzWHc != this.zzYM()) {
            this.zzYCT();
        }
    }

    private void zzYCT() {
        this.zzWHc = this.zzYM();
        this.zzX5c = -1;
        this.zzqH = this.zzZeu;
        this.zzYYM = -1;
    }

    private int zzYM() {
        if (this.zzY5U != null) {
            return this.zzY5U.zzYqx();
        }
        return 0;
    }

    public int getCount() {
        this.zzWr5();
        if (this.zzYYM == -1) {
            this.zzYYM = zzZT1.zzab(this);
        }
        return this.zzYYM;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWvZ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZeu;
    }
}

