/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.internal.zzhr;
import com.aspose.words.zz56;
import com.aspose.words.zzF4;
import com.aspose.words.zzIN;
import com.aspose.words.zzWHL;
import com.aspose.words.zzWfo;
import com.aspose.words.zzX3f;
import com.aspose.words.zzXO7;
import com.aspose.words.zzXvn;
import com.aspose.words.zzZ9Y;
import com.aspose.words.zzZQf;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzIN zzZre;

    ChartSeriesCollection(zzIN dmlChart) {
        this.zzZre = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZre.zzWSU().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZre.zzWSU().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZre.zzWSU().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZre.zzWSU().clear();
        this.zzYcl(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzab(seriesName, values);
        chartSeries.zzYT3().zzWpk(ChartSeriesCollection.zzWA8(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzab(seriesName, yValues);
        chartSeries.zzYT3().zzWpk(ChartSeriesCollection.zzWpk(xValues));
        return chartSeries;
    }

    private ChartSeries zzab(String string, zzhr[] zzhrArray, double[] dArray) {
        if (zzhrArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzhrArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzhrArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzab(string, dArray);
        chartSeries.zzYT3().zzWpk(ChartSeriesCollection.zzab(zzhrArray));
        if (!this.zzZre.zzVXQ()) {
            this.zzYcl(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzab(seriesName, zzhr.zzab(dates), values);
    }

    private void zzYcl(boolean bl) {
        zzXvn zzXvn2 = zzYkh.zzab((Object)this.zzZre, zzXvn.class);
        if (zzXvn2 != null && zzXvn2.zzYH1().zzCJ()) {
            zzXvn2.zzYH1().zzZfq().zzWA8(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZre.zzW0z() != 15) {
            this.zzZre.zzWYa(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzab(seriesName, yValues);
        chartSeries.zzZF1().zzZdL().zzWA8(3, this.zzZre.zzm6());
        chartSeries.zzYT3().zzWpk(ChartSeriesCollection.zzWpk(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzYr2().zzWpk(ChartSeriesCollection.zzWpk(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzab(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZre);
        chartSeries.setName(string);
        this.zzWmh(chartSeries);
        chartSeries.zzZbM(this.zzZre.zzjU().zzWZV() + 1);
        chartSeries.zzWOg(this.zzZre.zzjU().zzX9w() + 1);
        chartSeries.zzVTk().zzWpk(ChartSeriesCollection.zzWpk(dArray));
        this.zzZre.zzWO3().zzXql();
        this.zzZre.zzWSU().zzWmD(chartSeries);
        return chartSeries;
    }

    private void zzWmh(ChartSeries chartSeries) {
        chartSeries.zzZF1().zzZdL().zzWA8(5, new zzX3f());
        switch (this.zzZre.zzW0z()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzab(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzab(chartSeries, 5);
                ChartSeriesCollection.zzWl3(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzab(chartSeries, 1);
                ChartSeriesCollection.zzWl3(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzXcf(chartSeries);
            }
        }
    }

    private static void zzXcf(ChartSeries chartSeries) {
        zzX3f zzX3f2 = new zzX3f();
        zzX3f2.setOutline(new zz56());
        zzZ9Y zzZ9Y2 = new zzZ9Y();
        zzZ9Y2.zzWkR(1);
        zzX3f2.getOutline().setFill(new zzF4(zzZ9Y2));
        zzX3f2.getOutline().zzYlW(19050.0);
        chartSeries.zzZF1().zzZdL().zzWA8(5, zzX3f2);
    }

    private static void zzWl3(ChartSeries chartSeries) {
        zzX3f zzX3f2 = new zzX3f();
        zzX3f2.setOutline(new zz56());
        zzX3f2.getOutline().setFill(new zzWHL());
        zzX3f2.getOutline().setEndCap(0);
        zzX3f2.getOutline().zzYlW(19050.0);
        chartSeries.zzZF1().zzZdL().zzWA8(5, zzX3f2);
    }

    private static void zzab(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzCm());
        chartMarker.zzXs6().zzWA8(0, n);
        chartSeries.zzZF1().zzZdL().zzWA8(4, chartMarker);
    }

    private static zzZQf zzWpk(double[] dArray) {
        int n = 0;
        zzZQf zzZQf2 = new zzZQf(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZQf2.zztk(new zzXO7(n, d, "General"));
            }
            ++n;
        }
        zzZQf2.zzXhz(dArray.length);
        return zzZQf2;
    }

    private static zzZQf zzab(zzhr[] zzhrArray) {
        int n = 0;
        zzZQf zzZQf2 = new zzZQf(2);
        zzhr[] zzhrArray2 = zzhrArray;
        int n2 = zzhrArray.length;
        for (int i = 0; i < n2; ++i) {
            zzhr zzhr2 = zzhrArray2[i];
            zzZQf2.zztk(new zzXO7(n++, zzhr2.zzXTm(), "m/d/yyyy"));
        }
        zzZQf2.zzXhz(zzhrArray.length);
        return zzZQf2;
    }

    private static zzZQf zzWA8(String[] stringArray) {
        int n = 0;
        zzZQf zzZQf2 = new zzZQf(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZQf2.zztk(new zzWfo(n++, string));
        }
        zzZQf2.zzXhz(stringArray.length);
        return zzZQf2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZre.zzWSU().getCount();
    }
}

