/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXu;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWyr;
import com.aspose.words.net.System.Data.zzYBY;
import com.aspose.words.net.System.Data.zzZGo;
import com.aspose.words.net.System.Data.zzZMp;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYIF;
    private final DataColumnCollection zzWem;
    private final ConstraintCollection zzZrp;
    private final zzZMp zzZvT;
    private ResultSet zzYVV;
    private String zzW8D;
    private DataSet zzAK;
    private String zzRo;
    private UniqueConstraint zzZ8B;
    private boolean zzYvc;
    private final List<DataTableEventListener> zzhM;
    private final Set<DataRow> zzWwd;
    private DataRelationCollection zz0t;

    public DataTable() {
        this.zzYIF = new DataRowCollection(this);
        this.zzWem = new DataColumnCollection(this);
        this.zzZrp = new ConstraintCollection(this);
        this.zzZvT = new zzZMp(this);
        this.zzRo = "";
        this.zzYvc = true;
        this.zzhM = new ArrayList<DataTableEventListener>();
        this.zzWwd = new HashSet<DataRow>();
        this.zz0t = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzYIF = new DataRowCollection(this);
        this.zzWem = new DataColumnCollection(this);
        this.zzZrp = new ConstraintCollection(this);
        this.zzZvT = new zzZMp(this);
        this.zzRo = "";
        this.zzYvc = true;
        this.zzhM = new ArrayList<DataTableEventListener>();
        this.zzWwd = new HashSet<DataRow>();
        this.zz0t = new DataRelationCollection();
        this.zzW8D = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYBY.zzWAe(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYIF = new DataRowCollection(this);
        this.zzWem = new DataColumnCollection(this);
        this.zzZrp = new ConstraintCollection(this);
        this.zzZvT = new zzZMp(this);
        this.zzRo = "";
        this.zzYvc = true;
        this.zzhM = new ArrayList<DataTableEventListener>();
        this.zzWwd = new HashSet<DataRow>();
        this.zz0t = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYVV = resultSet;
        this.zzW8D = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYVV != null) {
            if (this.zzYVV.getStatement() != null) {
                this.zzYVV.getStatement().getConnection().close();
            }
            this.zzYVV = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzW8D;
    }

    public void setTableName(String tableName) {
        this.zzW8D = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzWem.getCount();
    }

    public String getColumnName(int index) {
        return this.zzWem.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYVV;
    }

    public DataSet getDataSet() {
        return this.zzAK;
    }

    final void zzZSY(DataSet dataSet) {
        this.zzAK = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzAK.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zz0t.add(dataRelation);
        }
        return this.zz0t;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzAK.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYIF;
    }

    public DataColumnCollection getColumns() {
        return this.zzWem;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZrp;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZ8B == null) {
            return new DataColumn[0];
        }
        return this.zzZ8B.getColumns();
    }

    final void zzZMp(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZ8B != null) {
                this.zzZ8B.zzXX6(false);
                this.getConstraints().remove(this.zzZ8B);
                this.zzZ8B = null;
            }
            return;
        }
        if (this.zzZ8B != null && DataColumn.areColumnSetsTheSame(value, this.zzZ8B.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzWAe(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZ8B != null) {
            this.zzZ8B.zzXX6(false);
            this.getConstraints().remove(this.zzZ8B);
            this.zzZ8B = null;
        }
        UniqueConstraint.zzWAe(this.getConstraints(), uniqueConstraint);
        this.zzZ8B = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzRo;
    }

    public void setNamespace(String namespace) {
        this.zzRo = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzYvc;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzYvc = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWwd.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYBY.zzWAe(this.getResultSet(), this);
            zzYBY.zzYBY(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXu.zzZSY(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYBY.zzOk(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzhM.contains(listener)) {
            this.zzhM.add(listener);
        }
    }

    public void removeEventListener(zzZGo listener) {
        if (this.zzhM.contains(listener)) {
            this.zzhM.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzhM.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWwd.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzhM) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWwd.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzhM) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWwd.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzhM) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzhM) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzhM) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzWyr zzWAe(zzYBY[] zzYBYArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYBYArray.length];
        for (int i = 0; i < zzYBYArray.length; ++i) {
            dataColumnArray[i] = zzYBYArray[i].zzY7C();
        }
        DataTable dataTable = this;
        zzWyr zzWyr2 = dataTable.zzZvT.zzZSY(dataColumnArray);
        if (zzWyr2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzWyr2;
    }

    final zzZMp zzZBv() {
        return this.zzZvT;
    }

    final Set<DataRow> zzYMM() {
        return this.zzWwd;
    }
}

