/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzX8V;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzWsf = new ArrayList();
    private final Map<String, DataColumn> zzZsl = new HashMap<String, DataColumn>();
    private DataTable zzWzD;

    DataColumnCollection(DataTable table) {
        this.zzWzD = table;
    }

    public void add(DataColumn column) {
        if (zzX8V.zzWjt(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzX2Z(column.getColumnName());
        if (this.zzZsl.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZSY(this.zzWzD);
        column.setOrdinal(this.zzWsf.size());
        this.zzWsf.add(column);
        this.zzZsl.put(string, column);
        this.zzWzD.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWzD);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWzD);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzX8V.zzWjt(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzX2Z(columnName);
        DataColumn dataColumn = this.zzZsl.get(string);
        if (dataColumn != null) {
            int n = this.zzWsf.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzWsf.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzWsf.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzWsf.remove(n);
            this.zzZsl.remove(DataColumnCollection.zzX2Z(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzWzD.getRows()) {
                dataRow.remove(n);
            }
            this.zzWzD.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzWsf.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzWsf.iterator();
    }

    public void clear() {
        this.zzZsl.clear();
        this.zzWsf.clear();
    }

    final DataColumn[] zzWN3() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzWsf);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzWAe(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzWsf.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzWsf.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzX2Z(string);
            String string3 = DataColumnCollection.zzX2Z(dataColumn.getColumnName());
            this.zzZsl.remove(string3);
            this.zzZsl.put(string2, dataColumn);
            return;
        }
    }

    private static String zzX2Z(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

