/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWSo;
import com.aspose.words.internal.zzX8V;
import com.aspose.words.internal.zzXva;
import com.aspose.words.internal.zzZK7;
import com.aspose.words.internal.zzZOU;
import com.aspose.words.internal.zzlB;
import com.aspose.words.internal.zzsK;
import com.aspose.words.zzYfR;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWq9;
    private zzYfR zzXkB;

    Watermark(Document doc, zzYfR watermarkProvider) {
        this.zzWq9 = doc;
        this.zzXkB = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzYsF(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzWAe(text, textWatermarkOptions, this.zzWq9);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzlB.zzYBY((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWq9, 75);
        shape.getImageData().setImage(image);
        this.zzWAe(shape, options, this.zzWq9);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzlB.zzYBY((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWq9, 75);
        shape.getImageData().setImage(imagePath);
        this.zzWAe(shape, options, this.zzWq9);
    }

    public final int getType() {
        Shape shape = this.zzXkB.get();
        if (shape == null) {
            return 2;
        }
        shape.zzZKg();
        if (shape.zzVQU()) {
            return 0;
        }
        if (shape.zzWAM()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzXkB.add(shape);
    }

    public final void remove() {
        this.zzXkB.remove();
    }

    private static void zzYsF(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzsK.zzXfH(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzlB.zzWAe(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzWAe(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYBY(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzOk(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYBY(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzY8O() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzj1()) / d2) > (double)(f = pageSetup.zzVWW())) {
            d = (double)f / d3;
        }
        shape.zzXw6(zzZOU.zzZGo(d2 * d, 2, zzXva.zzWhX));
        shape.zzWks(zzZOU.zzZGo(d3 * d, 2, zzXva.zzWhX));
    }

    private Shape zzWAe(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzWAe(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzOk(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzWAe(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzWQO() ? 1.0f : textWatermarkOptions.getFontSize();
        zzWSo zzWSo2 = document.zzYlq().zzZGo(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzWSo2.zzWXc(shape.getTextPath().getText());
        if (textWatermarkOptions.zzWQO()) {
            l = Watermark.zzWAe(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXw6(zzZOU.zzZGo(Float.intBitsToFloat(n), 2, zzXva.zzWhX));
        shape.zzWks(zzZOU.zzZGo(zzZK7.zzYqB(l), 2, zzXva.zzWhX));
    }

    private static long zzWAe(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzj1();
        float f2 = pageSetup.zzVWW();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZK7.zzYqB(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZK7.zzYwE(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZK7.zzYqB(l) >= Float.intBitsToFloat(n)) {
            return zzZK7.zzYwE(f2 / f3, f2);
        }
        float f6 = f;
        return zzZK7.zzYwE(f6, f6 * f3);
    }

    private static void zzOk(Shape shape, String string) {
        shape.setName(zzX8V.zzYBY("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

