/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzlB;
import com.aspose.words.zzWPG;
import com.aspose.words.zzWqa;
import com.aspose.words.zzYy;

public final class Section
extends CompositeNode<Node>
implements zzWqa {
    private zzWPG zzYiB;
    private PageSetup zzYHI;
    private HeaderFooterCollection zzXEw;

    public Section(DocumentBase doc) {
        this(doc, new zzWPG());
    }

    Section(DocumentBase doc, zzWPG sectPr) {
        super(doc);
        this.zzYiB = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzXEw == null) {
            this.zzXEw = new HeaderFooterCollection(this);
        }
        return this.zzXEw;
    }

    public final PageSetup getPageSetup() {
        if (this.zzYHI == null) {
            Section section = this;
            this.zzYHI = new PageSetup(section, section.getDocument().zzYkc(), this.getDocument().getStyles(), new zzWAe(this));
        }
        return this.zzYHI;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzY9Q();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYV5(!value);
    }

    final zzWPG zzZ4p() {
        return this.zzYiB;
    }

    final void zzZGo(zzWPG zzWPG2) {
        this.zzYiB = zzWPG2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzWAe(boolean bl, zzYy zzYy2) {
        zzWPG zzWPG2;
        Section section = (Section)super.zzWAe(bl, zzYy2);
        zzWPG zzWPG3 = this.zzYiB;
        section.zzYiB = zzWPG2 = (zzWPG)zzWPG3.zz6b();
        section.zzYHI = null;
        section.zzXEw = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWAe(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzYBY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzZSY(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzZSY(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzY2j(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzXTz(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzY2j(n) == null;
            }
        }
        return false;
    }

    final void zzZGo(Shape shape, boolean bl) {
        this.zzWAe(shape, 4, bl);
        this.zzWAe(shape, 0, bl);
        this.zzWAe(shape, 1, bl);
    }

    private void zzWAe(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzWyf() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZAL()) {
                if (!shape.zzZKg()) continue;
                shape.remove();
            }
        }
    }

    private void zzZSY(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYBY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYiB.zzYcz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzYkc().zzXXl.zzYDq(key);
        }
        return zzWPG.zzXXU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYiB.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzYkc().zzXXl.zzVI(key, value);
            return;
        }
        this.zzYiB.zzVI(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYiB.clear();
    }

    final boolean zzVP7() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzVXn() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzWAe
    implements zzWqa {
        private Section zzZXg;

        zzWAe(Section section) {
            this.zzZXg = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYLL().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYLL().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYLL().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzWqa zzYLL() {
            Document document = zzlB.zzWAe((Object)this.zzZXg.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZXg;
        }
    }
}

