/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWIV;
import com.aspose.words.internal.zzeA;

public abstract class SaveOptions {
    private boolean zzrP;
    private boolean zzW4H = true;
    private boolean zzZmD = false;
    private boolean zzYuH = true;
    private boolean zzWIt;
    private String zzY02;
    private boolean zzXhN;
    private boolean zzWgW = false;
    private boolean zzYka = true;
    private int zzX3K = 1;
    private int zzT3 = 1;
    private int zzXBG = 0;
    private String zzHq = "";
    private boolean zzZfn = true;
    private boolean zzYIk = true;
    private boolean zzZJ1;
    private boolean zzaM;
    private int zzWnJ = 0;
    private boolean zzXPz = true;
    private boolean zzYlr = false;
    private boolean zzg9 = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZf2() {
        return false;
    }

    boolean zzzb() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYuH;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYuH = value;
    }

    public String getTempFolder() {
        return this.zzY02;
    }

    public void setTempFolder(String value) {
        this.zzY02 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWIt;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWIt = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXhN;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXhN = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWgW;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWgW = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYka;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYka = value;
    }

    public int getDmlRenderingMode() {
        return this.zzX3K;
    }

    public void setDmlRenderingMode(int value) {
        this.zzX3K = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXBG;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXBG = value;
    }

    public int getImlRenderingMode() {
        return this.zzT3;
    }

    public void setImlRenderingMode(int value) {
        this.zzT3 = value;
    }

    public String getDefaultTemplate() {
        return this.zzHq;
    }

    public void setDefaultTemplate(String value) {
        this.zzHq = value;
    }

    public boolean getUpdateFields() {
        return this.zzZfn;
    }

    public void setUpdateFields(boolean value) {
        this.zzZfn = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZJ1;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZJ1 = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzaM;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzaM = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYlr;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYlr = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZmD;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZmD = value;
    }

    final boolean zzVQG() {
        return this.zzYIk;
    }

    final boolean zzYRt() {
        return this.zzXPz;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzBw(zzWIV.zzZXY(zzeA.zzZ9c(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWnJ;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWnJ = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzrP;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzrP = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzg9;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzg9 = value;
    }

    final boolean zzYgY() {
        return this.zzW4H;
    }
}

