/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzlB;
import com.aspose.words.zzYsI;
import com.aspose.words.zzYvu;
import com.aspose.words.zzZ8G;
import com.aspose.words.zzZVI;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzYsI,
Iterable<T> {
    private Node zzak;
    private CompositeNode zzYTn;
    private DocumentBase zzYjH;
    private boolean zzZKf;
    private int zzZKz;
    private int zzVPk;
    private Node zzVUI;
    private int zzXDo;
    private zzYvu zzWAB;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzZVI.zzY8S(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZVI(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzYvu matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYTn = container;
        this.zzYjH = container.getDocument();
        this.zzWAB = matcher;
        this.zzZKf = isDeep;
        this.zzWSb();
    }

    public Node get(int index) {
        try {
            this.zzZf6();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzVPk == index) {
                return this.zzVUI;
            }
            int n = index - this.zzVPk;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXxH(nodeCollection.zzVUI, n);
            if (node != null) {
                this.zzVPk = index;
                this.zzVUI = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZKf) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYTn.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZKf) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYTn.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzYEK();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ8G(this);
    }

    final <TNode extends Node> zzZ8G<TNode> zzqk() {
        return new zzZ8G(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzYEK() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzlB.zzWAe(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXxH(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZOE(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZyg(curNode, true);
    }

    private Node zzZyg(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzak = node;
        do {
            node2 = this.zzak;
            Node node3 = this.zzZKf ? this.zzWAe(true, this.zzak) : (this.zzak = this.zzWAB.zzZFM() ? this.zzZGo(true, this.zzak) : this.zzYBY(true, this.zzak));
        } while (this.zzak != null && !this.zzWAB.zzYbw(this.zzak));
        return node2;
    }

    private Node zzZOE(Node node, boolean bl) throws Exception {
        while ((this.zzZKf ? this.zzWAe(bl, node) : (node = this.zzWAB.zzZFM() ? this.zzZGo(bl, node) : this.zzYBY(bl, node))) != null && !this.zzWAB.zzYbw(node)) {
        }
        return node;
    }

    private Node zzWAe(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzYTn);
        }
        return node.previousPreOrder(this.zzYTn);
    }

    private Node zzYBY(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzYTn) {
                return this.zzYTn.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzYTn) {
            return this.zzYTn.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZGo(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzYTn ? this.zzYTn.zzYZS() : node.zz8h();
        } else {
            Node node3 = node2 = node == this.zzYTn ? this.zzYTn.zzWel() : node.zzZOK();
        }
        if (node2 == this.zzYTn.getNextSibling() || node2 == this.zzYTn.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZf6() {
        if (this.zzZKz != this.zzZOP()) {
            this.zzWSb();
        }
    }

    private void zzWSb() {
        this.zzZKz = this.zzZOP();
        this.zzVPk = -1;
        this.zzVUI = this.zzYTn;
        this.zzXDo = -1;
    }

    private int zzZOP() {
        if (this.zzYjH != null) {
            return this.zzYjH.zzzc();
        }
        return 0;
    }

    public int getCount() {
        this.zzZf6();
        if (this.zzXDo == -1) {
            this.zzXDo = zzZ8G.zzWAe(this);
        }
        return this.zzXDo;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzak;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYTn;
    }
}

