/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzlB;
import com.aspose.words.zzYTz;
import com.aspose.words.zzYWN;
import com.aspose.words.zzYsC;

public class ListFormat {
    private zzYTz zzW3F;
    private zzYsC zzY6s;
    private ListCollection zzCP;
    private ListLevel zzWic;
    private ListLevel zzWJF;

    ListFormat(zzYTz parentParaAttrs, zzYsC parentRunAttrs, ListCollection lists) {
        this.zzW3F = parentParaAttrs;
        this.zzY6s = parentRunAttrs;
        this.zzCP = lists;
    }

    public void applyBulletDefault() {
        if (this.zzCP.getCount() > 2046) {
            zzYWN.zzYBY(this.zzCP.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzWDp(listFormat.zzCP.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzWic = null;
    }

    public void applyNumberDefault() {
        if (this.zzCP.getCount() > 2046) {
            zzYWN.zzYBY(this.zzCP.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzWDp(listFormat.zzCP.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzWic = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzWic = null;
    }

    public void listIndent() throws Exception {
        if (this.zzZ7r() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzZ7r() + 1);
            ListFormat listFormat2 = this;
            this.zzWic = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzZ7r() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzZ7r() - 1);
            ListFormat listFormat2 = this;
            this.zzWic = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzlB.zzWAe((Object)this.zzCP.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzGo();
        }
        return this.zzZ7r();
    }

    public void setListLevelNumber(int value) {
        this.zzW3F.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzWic = null;
    }

    final int zzZ7r() {
        return (Integer)this.zzW3F.fetchParaAttr(1110);
    }

    final int zzGo() {
        Paragraph paragraph = zzlB.zzWAe((Object)this.zzW3F, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zz0K(1110, 1);
        }
        return this.zzZ7r();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzCP.zzZzJ(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzWDp(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzCP.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzWDp(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzWic = null;
    }

    final List zzcz() {
        int n = this.zzTV();
        if (n != 0) {
            return this.zzCP.zzZzJ(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzlB.zzWAe((Object)this.zzCP.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzWw8();
            }
            return this.zzYmj();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzYmj() {
        try {
            if (this.zzWic == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzYNt(this.zzZ7r()) : null;
                this.zzWic = listLevel != null ? new ListLevel(listLevel, this.zzY6s) : null;
            }
            return this.zzWic;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzWw8() {
        if (this.zzWJF == null) {
            List list = this.zzcz();
            ListLevel listLevel = list != null ? list.zzYNt(this.zzGo()) : null;
            this.zzWJF = listLevel != null ? new ListLevel(listLevel, this.zzY6s) : null;
        }
        return this.zzWJF;
    }

    final int getListId() {
        return (Integer)this.zzW3F.fetchParaAttr(1120);
    }

    private void zzWDp(int n) {
        Object object = this.zzW3F.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzhI().zzYqp() + this.getListLevel().zzhI().zz6h())) {
            n3 = 0;
        }
        this.zzW3F.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzWic = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzW3F.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzhI().zzYqp() + this.getListLevel().zzhI().zz6h();
        this.zzW3F.setParaAttr(1160, n4);
    }

    private int zzTV() {
        Paragraph paragraph = zzlB.zzWAe((Object)this.zzW3F, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zz0K(1120, 1);
        }
        return this.getListId();
    }
}

