/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz9l;
import com.aspose.words.internal.zzWIV;
import com.aspose.words.internal.zzXWC;
import com.aspose.words.internal.zzYsq;
import com.aspose.words.internal.zzlB;
import com.aspose.words.internal.zzsK;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVZz;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZpA = new HashMap();
    private static HashMap<Integer, Integer> zzWFF = new HashMap();
    private static HashMap<Integer, Integer> zzZRL = new HashMap();
    private static HashMap<Integer, Integer> zzYfg = new HashMap();
    private static HashMap<Integer, Integer> zzNH = new HashMap();
    private static HashMap<Integer, Integer> zzWm3 = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzlB.zzWAe(fileName, "fileName");
        try (zz9l zz9l2 = zzlB.zzYqZ(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZII(zz9l2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZII(zzXWC.zzWAe(stream));
    }

    static FileFormatInfo zzZII(zzYsq zzYsq2) throws Exception {
        if (zzYsq2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzVZz zzVZz2 = new zzVZz();
            zzYsq zzYsq3 = zzYsq2;
            zzVZz zzVZz3 = zzVZz2;
            return zzVZz2.zzYBY(zzYsq3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZGo(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zz8e(zzWIV.zzW9I(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzBw(zzWIV.zzW9I(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzsK.zzXH5(string = zzWIV.zzYXR(FileFormatUtil.zzWoB(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zz8e(FileFormatUtil.zzUR(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzBw(FileFormatUtil.zzWoB(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzWIV.zzYXR(FileFormatUtil.zzUR(saveFormat));
        if (zzsK.zzXH5(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzBw(zzWIV.zzZXY(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzWIV.zzYXR(FileFormatUtil.zzXZY(imageType));
    }

    static Exception zzZGo(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzCT(int n) {
        return zzWIV.toString(FileFormatUtil.zzUR(n));
    }

    static int zzBw(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzlB.zzWAe(zzNH, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWP7(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzlB.zzWAe(zzWm3, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzX41(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzWoB(int n) {
        return zzlB.zzWAe(zzZpA, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzUR(int n) {
        return zzlB.zzWAe(zzWFF, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXZY(int n) {
        return zzlB.zzWAe(zzZRL, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zz8e(int n) {
        return zzlB.zzWAe(zzYfg, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzVI(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzlB.zzYBY(zzNH, Integer.valueOf(n), Integer.valueOf(n2));
            zzlB.zzYBY(zzWFF, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzYfg.containsKey(n)) {
                zzlB.zzYBY(zzYfg, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzlB.zzYBY(zzZpA, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzlB.zzYBY(zzWm3, Integer.valueOf(n), Integer.valueOf(n4));
            zzlB.zzYBY(zzZRL, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzVI(11, 10, 10, 1);
        FileFormatUtil.zzVI(11, 0, 0, 1);
        FileFormatUtil.zzVI(12, 11, 11, 1);
        FileFormatUtil.zzVI(13, 20, 20, 1);
        FileFormatUtil.zzVI(13, 0, 254, 1);
        FileFormatUtil.zzVI(14, 21, 21, 1);
        FileFormatUtil.zzVI(15, 22, 22, 1);
        FileFormatUtil.zzVI(16, 23, 23, 1);
        FileFormatUtil.zzVI(18, 24, 24, 1);
        FileFormatUtil.zzVI(19, 25, 25, 1);
        FileFormatUtil.zzVI(20, 26, 26, 1);
        FileFormatUtil.zzVI(21, 27, 27, 1);
        FileFormatUtil.zzVI(24, 30, 30, 1);
        FileFormatUtil.zzVI(17, 31, 31, 1);
        FileFormatUtil.zzVI(25, 50, 50, 1);
        FileFormatUtil.zzVI(26, 45, 255, 1);
        FileFormatUtil.zzVI(27, 51, 51, 1);
        FileFormatUtil.zzVI(28, 0, 52, 1);
        FileFormatUtil.zzVI(29, 0, 53, 1);
        FileFormatUtil.zzVI(22, 60, 60, 1);
        FileFormatUtil.zzVI(23, 61, 61, 1);
        FileFormatUtil.zzVI(33, 40, 64, 1);
        FileFormatUtil.zzVI(40, 47, 255, 1);
        FileFormatUtil.zzVI(41, 48, 255, 1);
        FileFormatUtil.zzVI(34, 41, 255, 1);
        FileFormatUtil.zzVI(35, 46, 255, 1);
        FileFormatUtil.zzVI(37, 42, 255, 1);
        FileFormatUtil.zzVI(36, 44, 255, 1);
        FileFormatUtil.zzVI(30, 52, 255, 1);
        FileFormatUtil.zzVI(31, 70, 62, 1);
        FileFormatUtil.zzVI(32, 73, 63, 1);
        FileFormatUtil.zzVI(38, 71, 255, 1);
        FileFormatUtil.zzVI(8, 100, 255, 1);
        FileFormatUtil.zzVI(9, 105, 255, 1);
        FileFormatUtil.zzVI(6, 101, 255, 6);
        FileFormatUtil.zzVI(7, 102, 255, 7);
        FileFormatUtil.zzVI(5, 104, 255, 5);
        FileFormatUtil.zzVI(4, 0, 255, 4);
        FileFormatUtil.zzVI(3, 0, 255, 3);
        FileFormatUtil.zzVI(39, 72, 255, 1);
        FileFormatUtil.zzVI(2, 103, 255, 2);
    }
}

