/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz9w;
import com.aspose.words.internal.zzVQJ;
import com.aspose.words.internal.zzVZJ;
import com.aspose.words.internal.zzWaU;
import com.aspose.words.internal.zzWbv;
import com.aspose.words.internal.zzWvv;
import com.aspose.words.internal.zzX8V;
import com.aspose.words.internal.zzXPv;
import com.aspose.words.internal.zzXbk;
import com.aspose.words.internal.zzYLx;
import com.aspose.words.internal.zzYPH;
import com.aspose.words.internal.zzYsq;
import com.aspose.words.internal.zzZAv;
import com.aspose.words.internal.zzZK7;
import com.aspose.words.internal.zzeA;
import com.aspose.words.internal.zzlB;
import com.aspose.words.internal.zznK;
import com.aspose.words.internal.zzsK;
import com.aspose.words.zz4x;
import com.aspose.words.zz8;
import com.aspose.words.zz9R;
import com.aspose.words.zzHm;
import com.aspose.words.zzJu;
import com.aspose.words.zzRY;
import com.aspose.words.zzVRX;
import com.aspose.words.zzWB6;
import com.aspose.words.zzWBR;
import com.aspose.words.zzWHb;
import com.aspose.words.zzWPG;
import com.aspose.words.zzWPi;
import com.aspose.words.zzWWo;
import com.aspose.words.zzWYH;
import com.aspose.words.zzX1v;
import com.aspose.words.zzX7O;
import com.aspose.words.zzX9L;
import com.aspose.words.zzX9W;
import com.aspose.words.zzXLa;
import com.aspose.words.zzXMm;
import com.aspose.words.zzXt8;
import com.aspose.words.zzY51;
import com.aspose.words.zzY5s;
import com.aspose.words.zzY8S;
import com.aspose.words.zzYAe;
import com.aspose.words.zzYCT;
import com.aspose.words.zzYM3;
import com.aspose.words.zzYQV;
import com.aspose.words.zzYT3;
import com.aspose.words.zzYWN;
import com.aspose.words.zzYbj;
import com.aspose.words.zzYem;
import com.aspose.words.zzYfj;
import com.aspose.words.zzYs4;
import com.aspose.words.zzYsC;
import com.aspose.words.zzYz7;
import com.aspose.words.zzZII;
import com.aspose.words.zzZx;
import com.aspose.words.zzhL;
import com.aspose.words.zzuz;
import com.aspose.words.zzv4;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzYAe,
zzYs4,
zzYsC {
    private Document zzWq9;
    private Node zzYpz;
    private Node zzYdx;
    private zzWBR zzXA2;
    private Font zzWjf;
    private zzVZJ<zzWBR> zzXzd;
    private zzVZJ<zzJu> zzIE;
    private zzVZJ<zzWAe> zzYI9;
    private zz8 zzWmx = zz8.zz8W();
    private zzZII zzYiA = new zzZII();
    private RowFormat zzVZP;
    private CellFormat zzLy;
    private zzVZJ<zzv4> zzZCj;
    private int zzYu5 = 0;
    private int zzZo4 = -1;
    private int zzVk;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzWRm(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzWRm(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzWRm(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWAe(documentBuilder.getCurrentSection(), zzZx.zzY64(headerFooterType), 0, 0);
    }

    private void zzWRm(int n, int n2, int n3, int n4) {
        this.zzWq9.ensureMinimum();
        Section section = (Section)this.zzWq9.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzWAe(section, 1, n3, n4);
    }

    private void zzWAe(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZx.zzYcn(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzWq9, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzWq9));
            }
        }
        this.zzWAe(story, n2, n3);
    }

    private void zzWAe(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWAe(paragraph2, n3);
    }

    final void zzZGo(Paragraph paragraph, int n) {
        this.zzWAe(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzjm().zzZvL() ? zzX7O.zzZMp(this.zzWq9, fieldName) : zzX7O.zzXTz(this.zzjm(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzWAe(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzWAe(field, isAfter, false);
    }

    private boolean zzWAe(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWPi zzWPi2 = field.getFormat().zzCK();
        Inline inline = zzWPi2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzWAe(inline.zzXCz(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zz4x.zzWAe(this.zzWq9, bookmarkName) : zz4x.zzYBY(this.zzWq9, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzX32() == 6) {
            this.zzYBY((Paragraph)node.zzZJH(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYWN.zzYkm(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzYBY(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWAe(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzVe(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzWAe(cell, characterIndex);
    }

    private void zzYBY(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzX32() == 6) {
            this.zzVQD(node);
        } else {
            Node node2 = node;
            if (zzYWN.zzxo(node2.getNodeType())) {
                Paragraph paragraph = zzYWN.zzYkm(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzVQD(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzX32() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzVQD(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzVk = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZ9e();
            return;
        }
        if (!this.zzWBe()) {
            this.zzZ9e();
        }
    }

    private boolean zzWBe() {
        Node node = this.zzjm();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzjm(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzWAe(inline.zzXCz(), true);
            return true;
        }
        return false;
    }

    private void zzZ9e() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWAe(documentBuilder.getCurrentParagraph().zzVWP(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzVe(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXQR() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzjm().zzXmD(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzYZ9();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzWAe(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzWIR(text, false);
    }

    public void writeln(String text) {
        this.zzWIR(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzXJd();
        Paragraph paragraph = this.getCurrentParagraph();
        zzYM3 zzYM32 = new zzYM3(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzWq9, this.zzXnA(), this.zzVVf());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzYBY(this.zzjm(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYM32.dispose();
        }
        if (this.getDocument().zzXkY()) {
            zzXMm.zzZGo(paragraph, this.getDocument().zzXzO());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZJR() {
        zzWBR zzWBR2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzXJd();
        Node node = this.zzjm();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzYA(false);
        } else {
            run2 = run = (Run)node.zzYq4(21);
        }
        if (run2 == null && zzlB.zzYbw(node, paragraph.zzXYX())) {
            run = paragraph.zzXYX();
        }
        if (run != null) {
            cloneable = run.zzXCz();
            zzWBR2 = (zzWBR)((zzWWo)cloneable).zz6b();
        } else {
            cloneable = paragraph.zzVWP();
            zzWBR2 = (zzWBR)((zzWWo)cloneable).zz6b();
        }
        zzWBR zzWBR3 = zzWBR2;
        Paragraph paragraph2 = new Paragraph(this.zzWq9, this.zzXnA(), zzWBR3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYM3 zzYM32 = new zzYM3(this.zzWq9);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYBY(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYM32.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzX1v.zzZMp(this);
    }

    public void insertBreak(int breakType) {
        this.zzWXc(breakType, true);
    }

    final void zzWXc(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzYey(bl)) {
                    this.zzYN9(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzYey(bl)) {
                    this.zzYN9(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzYey(bl)) {
                    this.zzXxA(1);
                }
                return;
            }
            case 5: {
                if (this.zzYey(bl)) {
                    this.zzXxA(2);
                }
                return;
            }
            case 3: {
                if (this.zzYey(bl)) {
                    this.zzXxA(0);
                }
                return;
            }
            case 6: {
                if (this.zzYey(bl)) {
                    this.zzXxA(3);
                }
                return;
            }
            case 7: {
                if (this.zzYey(bl)) {
                    this.zzXxA(4);
                }
                return;
            }
            case 8: {
                this.zzYN9(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzsK.zzXH5(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzX8V.zzYBY("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzXJd();
        return zzYWN.zzWAe(fieldType, updateField, this.zzVVf(), this.zzjm(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzXJd();
        return zzYWN.zzWAe(fieldCode, this.zzVVf(), this.zzjm(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzXJd();
        return zzYWN.zzWAe(fieldCode, fieldValue, this.zzVVf(), this.zzjm(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzlB.zzYBY((Object)displayText, "displayText");
        zzlB.zzYBY((Object)urlOrBookmark, "hrefOrBookmark");
        zzXLa zzXLa2 = this.zzYBY(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzXLa2.zzYBY(documentBuilder.zzYPS(88, true));
        return zzYWN.zzWAe(zzXLa2.getStart(), zzXLa2.getSeparator(), zzXLa2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzYUW(70);
        if (zzsK.zzXH5(name)) {
            this.startBookmark(name);
        }
        this.zz8Y(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzW8t(70);
        String string = zzsK.zzXH5(fieldValue) ? fieldValue : FormField.zzX7C;
        Run run = new Run(this.zzWq9, string, this.zzVVf());
        this.insertNode(run);
        Node node = this.zzYPS(70, true);
        if (zzsK.zzXH5(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXRT(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzYBY((Paragraph)node.zzZJH(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzYUW(71);
        if (zzsK.zzXH5(name)) {
            this.startBookmark(name);
        }
        this.zz8Y(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzYPS(71, false);
        if (zzsK.zzXH5(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXRT(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzYUW(83);
        if (zzsK.zzXH5(name)) {
            this.startBookmark(name);
        }
        this.zz8Y(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzYPS(83, false);
        if (zzsK.zzXH5(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXRT(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzWq9, footnoteType, !zzsK.zzXH5(referenceMark), referenceMark, this.zzVVf());
        Style style = this.getDocument().getStyles().zzWdi(zzYWN.zzV5(footnoteType));
        footnote.zzXCz().set(50, style.zzZWR());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzWq9);
        Style style2 = this.getDocument().getStyles().zzWdi(zzYWN.zzVYE(footnoteType));
        paragraph.zzhI().set(1000, style2.zzZWR());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzWq9, '\u0002', new zzWBR()) : new Run(this.zzWq9, footnote.getReferenceMark(), new zzWBR());
        inline.zzXCz().set(50, style.zzZWR());
        paragraph.appendChild(inline);
        if (zzsK.zzXH5(footnoteText)) {
            Node node = this.zzjm();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzVQD(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzfP(zzYsq zzYsq2) throws Exception {
        return this.zzWAe(zzYsq2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzfP(zzYsq.zzYBY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzWAe(zzYsq zzYsq2, double d, double d2) throws Exception {
        return this.zzWAe(zzYsq2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzWAe(zzYsq.zzYBY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzZAv zzZAv2 = new zzZAv();){
            zzYPH.zzWAe(image, zzZAv2);
            Shape shape = this.zzWAe(zzZAv2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzlB.zzWAe(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzXPv.zzP7(fileName);
        try {
            Shape shape = this.zzWAe((zzYsq)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzYsq)object).close();
            }
        }
    }

    private Shape zzWAe(zzYsq zzYsq2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzYsq2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzlB.zzXTz(zzYsq2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWAe(zzYsq.zzYBY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        Shape shape;
        Object object2;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl = zzWbv.zzWku(imageBytes);
        boolean bl2 = false;
        if (zzWbv.zzZQJ(imageBytes)) {
            object2 = new zzYPH(imageBytes);
            bl2 = true;
            ((zzXbk)object2).dispose();
        }
        object2 = null;
        boolean bl3 = this.zzWq9.getCompatibilityOptions().getMswVersion() > 12 || this.zzWq9.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzWq9, 0);
            object = new zzYCT();
            ((zzX9W)object).zzWAe(zzX9L.zzVVJ("rect"));
            ((zzYCT)object).zzWAe(new zzYz7());
            ((zzYCT)object).zzXWN().zzWdk().zzZSY(this.zzWq9);
            zzYem zzYem2 = new zzYem();
            zzYem2.zzYBY(new zzWHb(this.zzWq9.zzVS9(), ""));
            zzYem2.zzWAe(new zzYbj());
            ((zzVRX)object).zzWAe(zzYem2);
            shape.zzZKZ(75);
            shape.zzWyr((zzVRX)object);
            if (bl) {
                ((zzYCT)object).zzXWN().zzWdk().setExtensions(new zzYLx<zzuz>());
                zzuz zzuz2 = zzuz.zzWAe(imageBytes, this.zzWq9);
                ((zzYCT)object).zzXWN().zzWdk().getExtensions().zzOk(zzuz2.getUri(), zzuz2);
            }
        } else {
            shape = new Shape((DocumentBase)this.zzWq9, 75);
        }
        shape.zzWAe(this.zzVVf());
        if (bl) {
            imageBytes = shape.getImageData().zzWAe(imageBytes, new zzY5s(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), bl3 ? 6 : 2);
        }
        if (bl3 && bl2) {
            ((zzYCT)shape.zzWkV()).zzXWN().zzWdk().zzZS8(imageBytes);
            object = zzWbv.zzYzB(imageBytes);
            object2 = new zzY5s(((zznK)object).getWidthPoints(), ((zznK)object).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes(imageBytes);
        }
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzWAe(width, height, (zzY5s)object2);
        return shape;
    }

    private Shape zzWAe(zzYsq zzYsq2, String string, boolean bl, zzYsq zzYsq3) throws Exception {
        zzWB6 zzWB62 = zzWB6.zzZmq(string);
        Shape shape = this.zzWAe(zzYsq3, bl, zzWB62, null);
        zzWYH zzWYH2 = zzHm.zzWAe(zzYsq2, string, bl);
        return DocumentBuilder.zzWAe(null, false, shape, zzWB62.zzXQt, zzWYH2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWAe(zzYsq.zzYBY(stream), progId, asIcon, zzYsq.zzYBY(presentation));
    }

    private Shape zzWAe(String string, boolean bl, boolean bl2, zzYsq zzYsq2) throws Exception {
        zzWB6 zzWB62 = zzWB6.zzXza(zzeA.zzZ9c(string));
        return this.zzWAe(string, bl, bl2, zzYsq2, zzWB62);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWAe(fileName, isLinked, asIcon, zzYsq.zzYBY(presentation));
    }

    private Shape zzWAe(String string, String string2, boolean bl, boolean bl2, zzYsq zzYsq2) throws Exception {
        zzWB6 zzWB62 = zzWB6.zzZmq(string2);
        return this.zzWAe(string, bl, bl2, zzYsq2, zzWB62);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWAe(fileName, progId, isLinked, asIcon, zzYsq.zzYBY(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWB6 zzWB62 = zzWB6.zzXza(zzeA.zzZ9c(fileName));
        return this.zzWAe(fileName, isLinked, iconFile, iconCaption, zzWB62);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWB6 zzWB62 = zzWB6.zzZmq(progId);
        return this.zzWAe(fileName, isLinked, iconFile, iconCaption, zzWB62);
    }

    private Shape zzWAe(zzYsq zzYsq2, String string, String string2, String string3) throws Exception {
        zzWB6 zzWB62 = zzWB6.zzZmq(string);
        Shape shape = this.zzWAe(string2, string3, zzWB62);
        zzWYH zzWYH2 = zzHm.zzWAe(zzYsq2, string, true);
        return DocumentBuilder.zzWAe(null, false, shape, zzWB62.zzXQt, zzWYH2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWAe(zzYsq.zzYBY(stream), progId, iconFile, iconCaption);
    }

    final Shape zzWAe(zzY8S zzY8S2, zzYsq zzYsq2) throws Exception {
        Shape shape = this.zzYPH(zzYsq2);
        shape.zzZKZ(201);
        shape.getOleFormat().zzYBY(zzY8S2.zzXE9());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzXJd();
        if (this.zzxC()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zztC(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzRY zzRY2 = zzYWN.zzWAe(html, options, this);
        zzRY2.zzZQH();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzXJd();
        return zzYWN.zzWAe(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzXJd();
        return zzYWN.zzWAe(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXt8 zzXt82 = new zzXt8();
        return zzXt82.zzWAe(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYQV(this).zzWAe(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYQV(this).zzWAe(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzWq9, 75);
        shape.zzWAe(this.zzVVf());
        shape.zzYTi(true);
        shape.getSignatureLine().zzWAe(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        double d = ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0);
        double d2 = ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0);
        Shape shape2 = shape;
        shape2.zzWAe(d2, d, null);
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZmO(this.zzWq9);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzxC() {
        boolean bl = false;
        if (this.zzjm().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzjm().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zztC(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzXJd();
        if (this.zzXQR() == null) {
            this.startTable();
        }
        if (this.zzXQR().zzXs1() == 1) {
            this.zzXQR().zzif();
        }
        if (this.zzXQR().zzXs1() == 3) {
            this.zzXQR().zzWrL();
        }
        return this.zzXQR().zzZ4S();
    }

    public Table startTable() {
        this.zzZCj.push(new zzv4(this));
        return this.zzXQR().startTable();
    }

    public Table endTable() {
        if (this.zzXQR() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXQR().endTable();
        this.zzZCj.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXQR() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXQR().endRow();
        if (this.zzWjf != null && this.zzWjf.getHidden()) {
            row.zzZVE().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWq9, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWq9, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZUH();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWq9, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzWJ1();
        bookmarkStart.zzZIY(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZUH();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzWJ1();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWq9, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYmP(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzWq9);
        this.zzZo4 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZo4 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWq9, this.zzZo4);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWq9, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzlB.zzYBY((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXJd();
        return zzhL.zzWAe(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzWq9;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzWq9) {
            return;
        }
        this.zzWq9 = value;
        this.zzVQD(null);
        this.zzXA2 = new zzWBR();
        this.zzXzd = null;
        this.zzIE = null;
        this.zzWjf = null;
        this.zzZCj = new zzVZJ();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzWjf == null) {
            DocumentBuilder documentBuilder = this;
            this.zzWjf = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzWjf;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzVZP == null) {
            this.zzVZP = new RowFormat(this);
        }
        return this.zzVZP;
    }

    public CellFormat getCellFormat() {
        if (this.zzLy == null) {
            this.zzLy = new CellFormat(this);
        }
        return this.zzLy;
    }

    final void zzrN(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzWBR zzWBR2 = this.getCurrentParagraph().zzVWP();
        this.zzWfZ().push(new zzWAe(this.zzVVf(), (zzWBR)zzWBR2.zz6b()));
    }

    public void popFont() {
        zzVZJ<zzWAe> zzVZJ2 = this.zzWfZ();
        if (zzVZJ2.size() > 0) {
            zzWAe zzWAe2 = (zzWAe)this.zzWfZ().pop();
            this.zzWAe(zzWAe2.zzXCz(), false);
            this.getCurrentParagraph().zzX2Z(zzWAe2.zzdT());
        }
    }

    final void zzE8() {
        this.zzVQL().push(this.zzVVf());
    }

    final void zzkD() {
        zzVZJ<zzWBR> zzVZJ2 = this.zzVQL();
        if (zzVZJ2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzWAe((zzWBR)documentBuilder.zzVQL().pop(), false);
        }
    }

    final void zzWcv() {
        this.zzoh().push(this.zzXnA());
    }

    final void zzVUy() {
        zzVZJ<zzJu> zzVZJ2 = this.zzoh();
        if (zzVZJ2.size() > 0) {
            this.getCurrentParagraph().zzWAe((zzJu)this.zzoh().pop());
        }
    }

    final zzXLa zzYBY(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzYUW(88);
        zzY51 zzY512 = new zzY51();
        zzY512.setTarget(string2);
        zzY512.setScreenTip(string3);
        if (bl) {
            zzY512.setSubAddress(string);
        } else {
            zzY512.setAddress(zzWvv.zz2z(string));
            zzY512.setSubAddress(zzWvv.zzsy(string));
        }
        this.zz8Y(zzY512.toString());
        FieldSeparator fieldSeparator = this.zzW8t(88);
        return new zzXLa(fieldStart, fieldSeparator, null);
    }

    final zzXLa zzVI(String string, String string2, String string3) {
        boolean bl = zzWvv.zzXw6(string);
        String string4 = bl ? zzWvv.zzsy(string) : string;
        return this.zzYBY(string4, bl, string2, string3);
    }

    final FieldEnd zzYau() {
        return this.zzYPS(88, true);
    }

    final zzWBR zzVVf() {
        zzWBR zzWBR2 = this.zzXA2;
        return (zzWBR)zzWBR2.zz6b();
    }

    final zzJu zzXnA() {
        zzJu zzJu2 = this.getCurrentParagraph().zzhI();
        return (zzJu)zzJu2.zz6b();
    }

    final zz8 zzYkg() {
        zz8 zz82 = this.zzZVE();
        return (zz8)zz82.zz6b();
    }

    final zzZII zzXzD() {
        zzZII zzZII2 = this.zzZ75();
        return (zzZII)zzZII2.zz6b();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzjm(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzjm().getNodeType() == 8;
    }

    private void zzWIR(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzZx.zzWsv(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzVSX(string2.substring(n4, n4 + n2));
                }
                switch (this.zzYu5) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzYN9(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzVSX(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzXJd();
        if (this.zzXQR() != null && this.zzXQR().zzXs1() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzjm().getParentNode().insertBefore(node, this.zzjm());
    }

    final void zzYPY(int n) {
        this.zzYey(true);
        this.zzXxA(n);
    }

    private void zzXxA(int n) {
        this.insertParagraph();
        zzYM3 zzYM32 = new zzYM3(this.getDocument());
        try {
            zzWPG zzWPG2 = this.getCurrentSection().zzZ4p();
            zzWPG zzWPG3 = (zzWPG)zzWPG2.zz6b();
            Section section = new Section(this.zzWq9, zzWPG3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzWq9));
            this.zzWq9.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYBY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYM32.dispose();
        }
    }

    final FieldStart zzYUW(int n) {
        this.zzXJd();
        return zzYWN.zzWAe(n, this.zzVVf(), this.zzjm(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zz8Y(String string) {
        return zzYWN.zzYBY(string, this.zzVVf(), this.zzjm(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzYPS(int n, boolean bl) {
        return zzYWN.zzYBY(n, bl, this.zzVVf(), this.zzjm(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzW8t(int n) {
        return zzYWN.zzYBY(n, this.zzVVf(), this.zzjm(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzXRT(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzWq9, new zzYT3(), this.zzVVf());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzYey(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXQR() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzVe(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzVSX(String string) {
        if (this.zzWEM(string)) {
            zzZK7 zzZK72 = new zzZK7(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zz9w zz9w2 : zzZK72.zzXhY(this.getParagraphFormat().getBidi())) {
                zzYfj zzYfj2 = zzYfj.zzVZM(zz9w2.zzYr4());
                zzWBR zzWBR2 = this.zzVVf();
                zzWBR2.zzVI(265, zzYfj2);
                if (zz9w2.zzYAy()) {
                    zzWBR2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzWq9, zz9w2.getText(), zzWBR2);
                this.insertNode(run);
            }
            return;
        }
        this.zzYN9(string);
    }

    private boolean zzWEM(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzWaU.zzZYY(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzWAe(zzWBR zzWBR2, boolean bl) {
        zzWBR zzWBR3;
        if (bl) {
            zzWBR zzWBR4 = zzWBR2;
            zzWBR3 = (zzWBR)zzWBR4.zz6b();
        } else {
            zzWBR3 = zzWBR2;
        }
        this.zzXA2 = zzWBR3;
    }

    final void zzM3() {
        this.zzXA2.clear();
    }

    final void zzZk() {
        if (this.zzZUH() != null) {
            zzZII zzZII2;
            zzZII zzZII3 = zzZII2 = this.zzZUH().zzZ75();
            this.zzYiA = (zzZII)zzZII3.zz6b();
            zzZII2.zzYBY(this.zzYiA);
        }
    }

    private Shape zzWAe(String string, boolean bl, boolean bl2, zzYsq zzYsq2, zzWB6 zzWB62) throws Exception {
        if (zzWB62 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzWAe(zzYsq2, bl2, zzWB62, string);
        zzWYH zzWYH2 = zzHm.zzWAe(string, bl, bl2, zzWB62);
        return DocumentBuilder.zzWAe(string, bl, shape, zzWB62.zzXQt, zzWYH2);
    }

    private Shape zzWAe(String string, boolean bl, String string2, String string3, zzWB6 zzWB62) throws Exception {
        if (zzWB62 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzeA.zzZ0d(string);
        }
        Shape shape = string2 != null ? this.zzWe4(string2, string3) : this.zzWAe(null, string3, zzWB62);
        zzWYH zzWYH2 = zzHm.zzWAe(string, bl, true, zzWB62);
        return DocumentBuilder.zzWAe(string, bl, shape, zzWB62.zzXQt, zzWYH2);
    }

    private static Shape zzWAe(String string, boolean bl, Shape shape, String string2, zzWYH zzWYH2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzZKZ(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYBY(zzWYH2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzWAe(zzYsq zzYsq2, boolean bl, zzWB6 zzWB62, String string) throws Exception {
        if (zzWB62 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzYsq2 != null) {
            return this.zzYPH(zzYsq2);
        }
        if (!bl) {
            return this.zzXME(zzHm.zzWGN().get("normal"));
        }
        String string2 = string != null ? zzeA.zzZ0d(string) : zzHm.zzr3(zzWB62.zzZTq);
        return this.zzWAe(zzWB62, string2);
    }

    private Shape zzWAe(String string, String string2, zzWB6 zzWB62) throws Exception {
        if (zzWB62 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzHm.zzr3(zzWB62.zzZTq);
        }
        if (string != null) {
            return this.zzWe4(string, string2);
        }
        return this.zzWAe(zzWB62, string2);
    }

    private Shape zzWAe(zzWB6 zzWB62, String string) throws Exception {
        if (zzWB62 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzHm.zzYgu(zzWB62.zzZTq);
        zzVQJ zzVQJ2 = new zzVQJ(byArray, null, string, this.getDocument().zzYlq());
        return this.zzXME(zzVQJ2.zzzw());
    }

    private Shape zzWe4(String string, String string2) throws Exception {
        zzVQJ zzVQJ2 = new zzVQJ(string, string2, this.getDocument().zzYlq());
        return this.zzXME(zzVQJ2.zzzw());
    }

    private Shape zzYPH(zzYsq zzYsq2) throws Exception {
        byte[] byArray = zzlB.zzXTz(zzYsq2);
        return this.zzXME(byArray);
    }

    private Shape zzXME(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzWq9, 1);
        shape.zzZKZ(75);
        shape.zzWAe(this.zzVVf());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        double d = imageSize.getHeightPoints();
        double d2 = imageSize.getWidthPoints();
        Shape shape2 = shape;
        shape2.zzWAe(d2, d, null);
        return shape;
    }

    private void zzWAe(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYBY(compositeNode, n);
            return;
        }
        this.zzZGo(compositeNode, n);
    }

    private void zzYBY(CompositeNode compositeNode, int n) {
        zz9R zz9R2 = zz9R.zzXco(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zz9R2.zzWAe(null, true, true, true, false, true);
            node = zz9R2.getNode();
            if (zz9R2.zzYVa() && (!node.isComposite() || node.zzX32() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzZdA().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzYBY(null, node);
            this.zzVk = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZGo(CompositeNode compositeNode, int n) {
        zz9R zz9R2 = zz9R.zzYH1(compositeNode);
        while (zz9R2.getNode() != compositeNode || !zz9R2.zzYVa()) {
            int n2;
            Node node = zz9R2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZdA().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzYBY(null, node);
                this.zzVk = n;
                return;
            }
            while (zz9R2.zzWAe(null, false, true, true, false, true) && zz9R2.zzYVa() && zz9R2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzXJd() {
        int n = this.zzVk;
        if (n == 0) {
            return;
        }
        this.zzVk = 0;
        Run run = zzlB.zzWAe((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWuF(n);
        }
    }

    private Run zzYN9(String string) {
        Run run = new Run(this.zzWq9, string, this.zzVVf());
        this.insertNode(run);
        return run;
    }

    final boolean zzXIT() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzbS() {
        return this.zzYu5;
    }

    final void zzXAe(int n) {
        this.zzYu5 = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzjm();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzjm();
        }
        return (Paragraph)this.zzjm().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzv4 zzXQR() {
        zzVZJ<zzv4> zzVZJ2 = this.zzZCj;
        if (zzVZJ2.size() > 0) {
            return (zzv4)this.zzZCj.peek();
        }
        return null;
    }

    private Cell zzZUH() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYuO();
    }

    private zzVZJ<zzWBR> zzVQL() {
        if (this.zzXzd == null) {
            this.zzXzd = new zzVZJ();
        }
        return this.zzXzd;
    }

    private zzVZJ<zzJu> zzoh() {
        if (this.zzIE == null) {
            this.zzIE = new zzVZJ();
        }
        return this.zzIE;
    }

    private zzVZJ<zzWAe> zzWfZ() {
        if (this.zzYI9 == null) {
            this.zzYI9 = new zzVZJ();
        }
        return this.zzYI9;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXA2.zzYcz(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzW1C(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzW1C(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXA2.zzVI(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWoc()) {
            this.getCurrentParagraph().zzVWP().zzVI(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXA2.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXA2.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWoc()) {
            this.getCurrentParagraph().zzVWP().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZVE().zzYcz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzZVE().zzYDq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZVE().zzX8Y(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZVE().zzVI(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZVE().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzZVE().clear();
        zz8.zz8W().zzYBY(this.zzZVE());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZ75().zzYcz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZ75().zzYDq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZ75().zzX8Y(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzlB.zzWAe(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZUH() != null ? this.zzZUH().getCellFormat() : this.getCellFormat();
            border.zzWAe(cellFormat);
        }
        this.zzZ75().zzVI(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZ75().clear();
    }

    private Node zzjm() {
        Node node = this.zzYpz != null && this.zzYpz.getParentNode() == null ? this.zzYdx : this.zzYpz;
        if (node != null && node.zzX32() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzVQD(Node node) {
        this.zzYpz = node;
        if (this.zzYpz != null) {
            this.zzYdx = this.zzYpz.getParentNode();
        }
    }

    private zz8 zzZVE() {
        if (this.zzXQR() != null && this.zzXQR().zzXs1() == 1) {
            return this.zzWmx;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzZVE();
        }
        return this.zzWmx;
    }

    private zzZII zzZ75() {
        if (this.zzXQR() != null && this.zzXQR().zzXs1() != 3) {
            return this.zzYiA;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYuO().zzZ75();
        }
        return this.zzYiA;
    }

    static final class zzWAe {
        private zzWBR zzXA2;
        private zzWBR zzYvT;

        public zzWAe(zzWBR zzWBR2, zzWBR zzWBR3) {
            this.zzXA2 = zzWBR2;
            this.zzYvT = zzWBR3;
        }

        public final zzWBR zzXCz() {
            return this.zzXA2;
        }

        public final zzWBR zzdT() {
            return this.zzYvT;
        }
    }
}

