/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz3I;
import com.aspose.words.internal.zz9l;
import com.aspose.words.internal.zzWpD;
import com.aspose.words.internal.zzX8V;
import com.aspose.words.internal.zzXA8;
import com.aspose.words.internal.zzYeC;
import com.aspose.words.internal.zzYsq;
import com.aspose.words.internal.zzYyx;
import com.aspose.words.internal.zzYzQ;
import com.aspose.words.internal.zzZAv;
import com.aspose.words.internal.zzlB;
import com.aspose.words.internal.zzuU;
import com.aspose.words.zz0y;
import com.aspose.words.zzVZz;
import com.aspose.words.zzWhm;
import com.aspose.words.zzX5n;
import com.aspose.words.zzX64;
import com.aspose.words.zzXsw;
import com.aspose.words.zzYLR;
import com.aspose.words.zzYvY;
import com.aspose.words.zzZ0N;
import com.aspose.words.zzZse;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzWAe(zzYsq zzYsq2, zzYsq zzYsq3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzlB.zzYBY((Object)zzYsq2, "srcStream");
        zzlB.zzYBY((Object)zzYsq3, "dstStream");
        zzlB.zzYBY((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYBY(zzYsq2, zzYsq3, certificateHolder, signOptions);
        zzYsq3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzWAe(zzYsq.zzYBY(srcStream), (zzYsq)zzYsq.zzZGo(dstStream), certHolder, signOptions);
    }

    private static void zzYBY(zzYsq zzYsq2, zzYsq zzYsq3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZGo(digitalSignature);
        }
        if (zzVZz.zzYBw(zzYsq2)) {
            DigitalSignatureUtil.zzWAe(zzYsq2, zzYsq3, digitalSignature, true);
            return;
        }
        zzVZz zzVZz2 = new zzVZz();
        zzYsq zzYsq4 = zzYsq2;
        zzVZz zzVZz3 = zzVZz2;
        FileFormatInfo fileFormatInfo = zzVZz2.zzYBY(zzYsq4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXA8 zzXA82 = new zzXA8(zzYsq2);
                int n = fileFormatInfo.zzWz8() == 1 ? 1 : 2;
                zzX64.zzWAe(zzXA82, digitalSignature, n);
                zzYsq3.zzWCC(0L);
                zzXA82.zzsq(zzYsq3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzWAe(fileFormatInfo.zzYHr(), zzYsq3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzWAe(zzYsq2, zzYsq3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzWAe(zzYsq2, zzYsq3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzlB.zzWAe(srcFileName, "srcFileName");
        zzlB.zzWAe(dstFileName, "dstFileName");
        try (zz9l zz9l2 = zzlB.zzYBY(srcFileName, 3, 1);){
            try (zz9l zz9l3 = zzlB.zzYBY(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWAe((zzYsq)zz9l2, (zzYsq)zz9l3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYzQ zzYzQ2 = zzYsq.zzZGo(dstStream);
        zzYsq zzYsq2 = zzYsq.zzYBY(srcStream);
        DigitalSignatureUtil.zzWAe(zzYsq2, (zzYsq)zzYzQ2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zz9l zz9l2 = zzlB.zzYBY(srcFileName, 3, 1);){
            try (zz9l zz9l3 = zzlB.zzYBY(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzOk(zz9l2, zz9l3);
            }
            return;
        }
    }

    private static void zzOk(zzYsq zzYsq2, zzYsq zzYsq3) throws Exception {
        zzVZz zzVZz2 = new zzVZz();
        zzYsq zzYsq4 = zzYsq2;
        zzVZz zzVZz3 = zzVZz2;
        FileFormatInfo fileFormatInfo = zzVZz2.zzYBY(zzYsq4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXA8 zzXA82 = new zzXA8(zzYsq2);
                zzXA82.zzkw().zzZyv("_xmlsignatures");
                zzXA82.zzkw().zzZyv("_signatures");
                zzYsq3.zzZNi(0L);
                zzXA82.zzsq(zzYsq3);
                zzYsq zzYsq5 = zzYsq3;
                zzYsq5.zzWCC(zzYsq5.zzWUq());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzuU zzuU2 = new zzuU(zzYsq2);
                zz3I zz3I2 = zzuU2.zzWAe(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zz3I2 != null) {
                    for (zzYeC zzYeC2 : zz3I2.zzWoP()) {
                        String string = zz3I2.zzWAe(zzYeC2);
                        zzuU2.zzZVW().remove(string);
                    }
                    zzuU2.zzZVW().remove(zz3I2.getName());
                    zzYeC zzYeC3 = zzuU2.zzWoP().zzYBV("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzuU2.zzWoP().remove(zzYeC3.getId());
                    zzuU2.zzYx1();
                }
                zzYsq3.zzZNi(0L);
                zzuU2.zzsq(zzYsq3);
                zzYsq zzYsq6 = zzYsq3;
                zzYsq6.zzWCC(zzYsq6.zzWUq());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzOk(zzYsq.zzYBY(srcStream), zzYsq.zzZGo(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zz9l zz9l2 = zzlB.zzYBY(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzY3J(zz9l2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzY3J(zzYsq zzYsq2) throws Exception {
        if (zzVZz.zzYBw(zzYsq2)) {
            return DigitalSignatureUtil.zzZNb(zzYsq2);
        }
        zzVZz zzVZz2 = new zzVZz();
        zzYsq zzYsq3 = zzYsq2;
        zzVZz zzVZz3 = zzVZz2;
        FileFormatInfo fileFormatInfo = zzVZz2.zzYBY(zzYsq3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzYsq2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzY3J(zzYsq.zzYBY(stream));
    }

    static zzZAv zzWAe(zzXA8 zzXA82, String string) throws Exception {
        zzYvY zzYvY2 = new zzYvY(zzXA82);
        if (zzYvY2.zzZRt()) {
            zzZAv zzZAv2 = zzYvY2.zzZvp(string);
            return zzZAv2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYJE(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzX8V.zzYBY("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWd7(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYJE(n);
    }

    private static void zzWAe(zzYsq zzYsq2, zzYsq zzYsq3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzuU zzuU2 = new zzuU(zzYsq2);
        zzZ0N zzZ0N2 = bl ? new zzZse(zzuU2) : new zzX5n(zzuU2);
        zzZ0N2.zzYBY(digitalSignature);
        zzYsq3.zzWCC(0L);
        zzuU2.zzsq(zzYsq3);
    }

    private static void zzWAe(zzYsq zzYsq2, zzYsq zzYsq3, DigitalSignature digitalSignature) throws Exception {
        zzXsw zzXsw2 = new zzXsw(zzYsq2);
        zz0y zz0y2 = new zz0y(zzXsw2);
        zz0y2.zzYBY(digitalSignature);
        zzYsq3.zzWCC(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzYsq zzYsq4 = zzYsq3;
        zzXsw zzXsw3 = zzXsw2;
        zzXsw3.zzWAe(zzYsq4, string, null);
    }

    private static void zzWAe(zzXA8 zzXA82, zzYsq zzYsq2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZAv zzZAv2 = DigitalSignatureUtil.zzWAe(zzXA82, string);
        zzZAv zzZAv3 = new zzZAv();
        DigitalSignatureUtil.zzWAe((zzYsq)zzZAv2, (zzYsq)zzZAv3, digitalSignature, false);
        zzXA8 zzXA83 = zzYvY.zzZGo(zzZAv3, string);
        zzXA83.zzsq(zzYsq2);
    }

    private static DigitalSignatureCollection zzZNb(zzYsq zzYsq2) throws Exception {
        zzYsq2.zzZNi(0L);
        zzuU zzuU2 = new zzuU(zzYsq2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zz3I zz3I2 = zzuU2.zzWAe(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zz3I2 != null) {
            for (zzYeC zzYeC2 : zz3I2.zzWoP()) {
                String string = zz3I2.zzWAe(zzYeC2);
                zz3I zz3I3 = zzuU2.zzZf(string);
                zz3I zz3I4 = zzuU2.zzWAe(zz3I3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWpD zzWpD2 = zzYyx.zzWQM(zz3I4.zzXhn().zzXtp());
                zzYLR.zzWAe(zz3I3.zzY9i(), zzWpD2, new zzWhm(zzuU2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

