/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzlB;
import com.aspose.words.zzXMm;
import com.aspose.words.zzXlG;
import com.aspose.words.zzYCd;
import com.aspose.words.zzYM3;
import com.aspose.words.zzYWN;
import com.aspose.words.zzYYB;
import com.aspose.words.zzYsI;
import com.aspose.words.zzYy;
import com.aspose.words.zzZ8G;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzYsI,
Iterable<T> {
    private Node zzir;
    private Node zzZVQ;
    private Node zzak;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXgs() {
        return this.zzYZS() != null;
    }

    final boolean zzZEq() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzY1a() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzXlG) {
                return true;
            }
            CompositeNode compositeNode = zzlB.zzWAe((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzY1a()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzir;
    }

    public Node getLastChild() {
        return this.zzZVQ;
    }

    final Node zzYZS() {
        return zzYWN.zzZMp(this.getFirstChild(), false);
    }

    final Node zzWel() {
        return zzYWN.zzXTz(this.getLastChild(), false);
    }

    final CompositeNode zzZjW() {
        return (CompositeNode)zzYWN.zzZMp(this.getFirstChild(), true);
    }

    final CompositeNode zz85() {
        return (CompositeNode)zzYWN.zzXTz(this.getLastChild(), true);
    }

    final Node zzNP() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYWN.zzxo((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzWkK() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYWN.zzxo((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzWAe(boolean bl, zzYy zzYy2) {
        CompositeNode compositeNode = (CompositeNode)super.zzWAe(bl, zzYy2);
        ((CompositeNode)super.zzWAe(bl, zzYy2)).zzZVQ = null;
        compositeNode.zzir = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZyg(node.zzWAe(true, zzYy2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYqZ(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYqZ(StringBuilder stringBuilder) {
        this.zzYbw(stringBuilder);
        zzlB.zzYBY(stringBuilder, this.zzZdA());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYBY(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYWN.zzZDH(nodeType);
            Node node2 = node = bl ? this.zzYZS() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zz8h() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzYCd.zzZGo(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzYCd.zzZSY(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ8G(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzWAe(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzWAe(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzWAe(oldChild, this, null, 1);
        if (documentBase.zzXkY() && zzXMm.zzZeZ(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzWAe(nodeChangingArgs);
        }
        Node node = this.zzZOE(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzYBY(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzYYB.zzZNi(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZyg(Node node) {
        node.getParentNode();
        if (this.zzZVQ == null) {
            node.zzWJr(null);
            node.zzY4q(null);
            this.zzir = node;
        } else {
            node.zzWJr(this.zzZVQ);
            node.zzY4q(null);
            this.zzZVQ.zzY4q(node);
        }
        this.zzZVQ = node;
        node.zzb2(this);
        return node;
    }

    final void zzWAe(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzYBY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYBY(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYWN.zzxo(node3.getNodeType())) continue;
            if (zzYWN.zzOk(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZdA().length();
    }

    String zzZdA() {
        return "";
    }

    final String zz0X() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYbw(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzYbw(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYqZ(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzWAe(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzYBY(visitor));
    }

    abstract int zzWAe(DocumentVisitor var1) throws Exception;

    abstract int zzYBY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzXTz(Node var1);

    final Node zzWAe(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzXmD(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzXTz(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzYM3(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzYM3)object).dispose();
            }
        }
        if ((object = documentBase.zzWAe(node, null, this, 0)) != null) {
            documentBase.zzWAe((NodeChangingArgs)object);
        }
        if (this.zzZVQ == null) {
            node.zzWJr(null);
            node.zzY4q(null);
            this.zzir = node;
            this.zzZVQ = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzYBY(node, node2);
            } else {
                this.zzZGo(node, this.zzir);
            }
        } else if (node2 != null) {
            this.zzZGo(node, node2);
        } else {
            this.zzYBY(node, this.zzZVQ);
        }
        node.zzb2(this);
        if (object != null) {
            documentBase.zzYBY((NodeChangingArgs)object);
        }
        if (documentBase.zzXkY()) {
            zzXMm.zzWAe(node, compositeNode, node3);
        }
        return node;
    }

    private void zzYBY(Node node, Node node2) {
        Node node3 = node2.zzVUW();
        node.zzWJr(node2);
        node.zzY4q(node3);
        node2.zzY4q(node);
        if (node3 == null) {
            this.zzZVQ = node;
            return;
        }
        node3.zzWJr(node);
    }

    private void zzZGo(Node node, Node node2) {
        Node node3 = node2.zzZu4();
        node.zzWJr(node3);
        node.zzY4q(node2);
        node2.zzWJr(node);
        if (node3 == null) {
            this.zzir = node;
            return;
        }
        node3.zzY4q(node);
    }

    private Node zzZOE(Node node) {
        if (node == this.zzir) {
            if (this.zzir == this.zzZVQ) {
                this.zzir = null;
                this.zzZVQ = null;
            } else {
                this.zzir = node.zzVUW();
                this.zzir.zzWJr(null);
            }
        } else {
            Node node2 = node.zzZu4();
            Node node3 = node.zzVUW();
            node2.zzY4q(node3);
            if (node3 == null) {
                this.zzZVQ = node2;
            } else {
                node3.zzWJr(node2);
            }
        }
        node.zzY4q(null);
        node.zzWJr(null);
        node.zzb2(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzak = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzak;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

