/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzY6D;
import com.aspose.words.internal.zzlB;
import com.aspose.words.zzW21;
import com.aspose.words.zzW9e;
import com.aspose.words.zzWJp;
import com.aspose.words.zzWTd;
import com.aspose.words.zzXB;
import com.aspose.words.zzYyO;
import com.aspose.words.zzZRI;
import com.aspose.words.zzZZi;
import com.aspose.words.zzZjA;
import com.aspose.words.zzZrQ;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZrQ zzZnr;

    ChartSeriesCollection(zzZrQ dmlChart) {
        this.zzZnr = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZnr.zzZ2a().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZnr.zzZ2a().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZnr.zzZ2a().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZnr.zzZ2a().clear();
        this.zzZf(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWAe(seriesName, values);
        chartSeries.zzWrR().zzZSY(ChartSeriesCollection.zzYbw(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWAe(seriesName, yValues);
        chartSeries.zzWrR().zzZSY(ChartSeriesCollection.zzZSY(xValues));
        return chartSeries;
    }

    private ChartSeries zzWAe(String string, zzY6D[] zzY6DArray, double[] dArray) {
        if (zzY6DArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzY6DArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzY6DArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzWAe(string, dArray);
        chartSeries.zzWrR().zzZSY(ChartSeriesCollection.zzWAe(zzY6DArray));
        if (!this.zzZnr.zzZqP()) {
            this.zzZf(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzWAe(seriesName, zzY6D.zzWAe(dates), values);
    }

    private void zzZf(boolean bl) {
        zzZZi zzZZi2 = zzlB.zzWAe((Object)this.zzZnr, zzZZi.class);
        if (zzZZi2 != null && zzZZi2.zzHk().zzXUI()) {
            zzZZi2.zzHk().zzWS6().zzh3(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZnr.zzXdj() != 15) {
            this.zzZnr.zzZMp(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzWAe(seriesName, yValues);
        chartSeries.zzXTl().zzY4W().zzh3(3, this.zzZnr.zzNf());
        chartSeries.zzWrR().zzZSY(ChartSeriesCollection.zzZSY(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzVYx().zzZSY(ChartSeriesCollection.zzZSY(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzWAe(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZnr);
        chartSeries.setName(string);
        this.zzXTz(chartSeries);
        chartSeries.zzXws(this.zzZnr.zzEP().zzWgS() + 1);
        chartSeries.zzVSX(this.zzZnr.zzEP().zzZg7() + 1);
        chartSeries.zzXCP().zzZSY(ChartSeriesCollection.zzZSY(dArray));
        chartSeries.zzWSs().zzZSY(chartSeries.zzXCP().zz6O());
        this.zzZnr.zzW2j().zzXW();
        this.zzZnr.zzYp8(chartSeries);
        return chartSeries;
    }

    private void zzXTz(ChartSeries chartSeries) {
        chartSeries.zzXTl().zzY4W().zzh3(5, new zzYyO());
        switch (this.zzZnr.zzXdj()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzWAe(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzWAe(chartSeries, 5);
                ChartSeriesCollection.zzZiX(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzWAe(chartSeries, 1);
                ChartSeriesCollection.zzZiX(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZ1f(chartSeries);
            }
        }
    }

    private static void zzZ1f(ChartSeries chartSeries) {
        zzYyO zzYyO2 = new zzYyO();
        zzYyO2.setOutline(new zzWTd());
        zzXB zzXB2 = new zzXB();
        zzXB2.zzWhh(1);
        zzYyO2.getOutline().setFill(new zzWJp(zzXB2));
        zzYyO2.getOutline().zzXTy(19050.0);
        chartSeries.zzXTl().zzY4W().zzh3(5, zzYyO2);
    }

    private static void zzZiX(ChartSeries chartSeries) {
        zzYyO zzYyO2 = new zzYyO();
        zzYyO2.setOutline(new zzWTd());
        zzYyO2.getOutline().setFill(new zzZjA());
        zzYyO2.getOutline().setEndCap(0);
        zzYyO2.getOutline().zzXTy(19050.0);
        chartSeries.zzXTl().zzY4W().zzh3(5, zzYyO2);
    }

    private static void zzWAe(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZPg());
        chartMarker.zzOv().zzh3(0, n);
        chartSeries.zzXTl().zzY4W().zzh3(4, chartMarker);
    }

    private static zzW21 zzZSY(double[] dArray) {
        int n = 0;
        zzW21 zzW212 = new zzW21(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzW212.zzZiX(new zzZRI(n, d, "General"));
            }
            ++n;
        }
        zzW212.zzWTk(dArray.length);
        zzW212.zzZRW();
        return zzW212;
    }

    private static zzW21 zzWAe(zzY6D[] zzY6DArray) {
        int n = 0;
        zzW21 zzW212 = new zzW21(2, false);
        zzY6D[] zzY6DArray2 = zzY6DArray;
        int n2 = zzY6DArray.length;
        for (int i = 0; i < n2; ++i) {
            zzY6D zzY6D2 = zzY6DArray2[i];
            zzW212.zzZiX(new zzZRI(n++, zzY6D2.zzZSU(), "m/d/yyyy"));
        }
        zzW212.zzWTk(zzY6DArray.length);
        zzW212.zzZRW();
        return zzW212;
    }

    private static zzW21 zzYbw(String[] stringArray) {
        int n = 0;
        zzW21 zzW212 = new zzW21(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzW212.zzZiX(new zzW9e(n++, string));
        }
        zzW212.zzWTk(stringArray.length);
        zzW212.zzZRW();
        return zzW212;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZnr.zzZ2a().size();
    }
}

