/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzlB;
import com.aspose.words.zzWSy;
import com.aspose.words.zzWWo;
import com.aspose.words.zzX5U;
import com.aspose.words.zzXaY;
import com.aspose.words.zzYWN;
import com.aspose.words.zzYs4;
import com.aspose.words.zzYy;
import com.aspose.words.zzZII;
import com.aspose.words.zzZx;
import com.aspose.words.zzjz;

public class Cell
extends CompositeNode<Node>
implements zzWSy,
zzYs4 {
    private zzZII zzYiA;
    private CellFormat zzLy;
    private ParagraphCollection zzYb2;
    private TableCollection zzYAv;

    public Cell(DocumentBase doc) {
        this(doc, new zzZII());
    }

    Cell(DocumentBase doc, zzZII cellPr) {
        super(doc);
        this.zzYiA = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzAG() {
        return (Cell)this.zzYZ9();
    }

    public Row getParentRow() {
        return (Row)this.zzZJH();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzWHF() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYBY(this, true);
        }
        return -1;
    }

    final int zzZ5M() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzZ5M();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzLy == null) {
            this.zzLy = new CellFormat(this);
        }
        return this.zzLy;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzYb2 == null) {
            this.zzYb2 = new ParagraphCollection(this);
        }
        return this.zzYb2;
    }

    public TableCollection getTables() {
        if (this.zzYAv == null) {
            this.zzYAv = new TableCollection(this);
        }
        return this.zzYAv;
    }

    final zzZII zzZ75() {
        return this.zzYiA;
    }

    final void zzWAe(zzZII zzZII2) {
        this.zzYiA = zzZII2;
    }

    @Override
    final Node zzWAe(boolean bl, zzYy zzYy2) {
        zzZII zzZII2;
        Cell cell = (Cell)super.zzWAe(bl, zzYy2);
        zzZII zzZII3 = this.zzYiA;
        cell.zzYiA = zzZII2 = (zzZII)zzZII3.zz6b();
        cell.zzLy = null;
        cell.zzYb2 = null;
        cell.zzYAv = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWAe(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzYBY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZx.zzX2Z(this);
    }

    @Override
    final boolean zzXTz(Node node) {
        return zzYWN.zzWCC(node);
    }

    final int zzWJ1() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzYZ9();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYiA.zzYcz(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzYiA.zzYcz(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzX5U zzX5U2 = zzlB.zzWAe(object, zzX5U.class);
        if (zzX5U2 != null && zzX5U2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzW6T(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzZII.zzXXU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzYiA.zzVI(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYiA.clear();
    }

    private Object zzW6T(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzlB.zzWAe((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzWAe(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXaY getInsertRevision() {
        Cell cell = this;
        return cell.zzYiA.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXaY value) {
        Cloneable cloneable = this;
        zzXaY zzXaY2 = value;
        cloneable = cloneable.zzYiA;
        ((zzWWo)cloneable).zzVI(14, zzXaY2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXaY getDeleteRevision() {
        Cell cell = this;
        return cell.zzYiA.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXaY value) {
        Cloneable cloneable = this;
        zzXaY zzXaY2 = value;
        cloneable = cloneable.zzYiA;
        ((zzWWo)cloneable).zzVI(12, zzXaY2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzjz getMoveFromRevision() {
        Cell cell = this;
        return cell.zzYiA.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzjz value) {
        Cloneable cloneable = this;
        zzjz zzjz2 = value;
        cloneable = cloneable.zzYiA;
        ((zzWWo)cloneable).zzVI(13, zzjz2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzjz getMoveToRevision() {
        Cell cell = this;
        return cell.zzYiA.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzjz value) {
        Cloneable cloneable = this;
        zzjz zzjz2 = value;
        cloneable = cloneable.zzYiA;
        ((zzWWo)cloneable).zzVI(15, zzjz2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzYiA.remove(13);
        cell = this;
        cell.zzYiA.remove(15);
    }

    final zzZII zzZS8(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzZII zzZII2 = new zzZII();
        this.zzWAe(3120, zzZII2);
        this.zzWAe(3140, zzZII2);
        this.zzWAe(3110, zzZII2);
        this.zzWAe(3130, zzZII2);
        this.zzWAe(3090, zzZII2);
        this.zzWAe(3100, zzZII2);
        this.zzWAe(3070, zzZII2);
        this.zzWAe(3080, zzZII2);
        if (bl && (tableStyle = zzlB.zzWAe((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYBY(this, zzZII2);
        }
        this.zzYiA.zzYBY((zzWWo)zzZII2);
        return zzZII2;
    }

    private void zzWAe(int n, zzZII zzZII2) {
        zzZII2.zzVI(n, this.fetchInheritedCellAttr(n));
    }
}

