/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzWSG;
import com.aspose.words.internal.zzlB;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZvC;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzZvC zzYwu;

    BorderCollection(zzZvC parent) {
        this.zzYwu = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzlB.zzYbw(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzZYa().equals(brColl.zzZYa()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzYwu.getPossibleBorderKeys().zzWAe(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzYwu.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzYwu, borderKey);
            this.zzYwu.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzYwu.getPossibleBorderKeys().zzrK().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzYwu.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzYwu.getPossibleBorderKeys().zzrK().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzNZ(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzYwu.getPossibleBorderKeys().zzrK().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzNZ(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzZYa().zzWAm();
    }

    public final void setColor(Color value) throws Exception {
        this.zzZ8P(zzWSG.zzYBY(value));
    }

    private zzWSG zzZYa() throws Exception {
        return this.get(0).zzZYa();
    }

    private void zzZ8P(zzWSG zzWSG2) throws Exception {
        Iterator iterator = this.zzYwu.getPossibleBorderKeys().zzrK().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzNZ(n)) continue;
            this.getByBorderType(n).zzZ8P(zzWSG2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzYwu.getPossibleBorderKeys().zzrK().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzNZ(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzYwu.getPossibleBorderKeys().zzrK().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzNZ(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzWAe(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzNZ(int n) {
        return n != 6 && n != 7;
    }

    static final class zzWAe
    implements Iterator<Border> {
        private BorderCollection zzWcH;
        private int zzXaC;

        zzWAe(BorderCollection borderCollection) {
            this.zzWcH = borderCollection;
            this.zzXaC = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzXaC >= this.zzWcH.getCount() - 1) {
                return false;
            }
            ++this.zzXaC;
            return true;
        }

        private Border zz91() {
            try {
                return this.zzWcH.get(this.zzXaC);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zz91();
        }
    }
}

