/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz14;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zz4c;
import com.aspose.words.net.System.Data.zzWNj;
import com.aspose.words.net.System.Data.zzYIy;
import com.aspose.words.net.System.Data.zzZTj;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzQS;
    private final DataColumnCollection zzYwy;
    private final ConstraintCollection zzXiP;
    private final zzWNj zzYJF;
    private ResultSet zzY0J;
    private String zzYoP;
    private DataSet zzWyx;
    private String zzJB;
    private UniqueConstraint zzEN;
    private boolean zzVYa;
    private final List<DataTableEventListener> zzZg7;
    private final Set<DataRow> zzu1;
    private DataRelationCollection zzZEb;

    public DataTable() {
        this.zzQS = new DataRowCollection(this);
        this.zzYwy = new DataColumnCollection(this);
        this.zzXiP = new ConstraintCollection(this);
        this.zzYJF = new zzWNj(this);
        this.zzJB = "";
        this.zzVYa = true;
        this.zzZg7 = new ArrayList<DataTableEventListener>();
        this.zzu1 = new HashSet<DataRow>();
        this.zzZEb = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzQS = new DataRowCollection(this);
        this.zzYwy = new DataColumnCollection(this);
        this.zzXiP = new ConstraintCollection(this);
        this.zzYJF = new zzWNj(this);
        this.zzJB = "";
        this.zzVYa = true;
        this.zzZg7 = new ArrayList<DataTableEventListener>();
        this.zzu1 = new HashSet<DataRow>();
        this.zzZEb = new DataRelationCollection();
        this.zzYoP = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzZTj.zzXMZ(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzQS = new DataRowCollection(this);
        this.zzYwy = new DataColumnCollection(this);
        this.zzXiP = new ConstraintCollection(this);
        this.zzYJF = new zzWNj(this);
        this.zzJB = "";
        this.zzVYa = true;
        this.zzZg7 = new ArrayList<DataTableEventListener>();
        this.zzu1 = new HashSet<DataRow>();
        this.zzZEb = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzY0J = resultSet;
        this.zzYoP = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzY0J != null) {
            if (this.zzY0J.getStatement() != null) {
                this.zzY0J.getStatement().getConnection().close();
            }
            this.zzY0J = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzYoP;
    }

    public void setTableName(String tableName) {
        this.zzYoP = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzYwy.getCount();
    }

    public String getColumnName(int index) {
        return this.zzYwy.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzY0J;
    }

    public DataSet getDataSet() {
        return this.zzWyx;
    }

    final void zzjA(DataSet dataSet) {
        this.zzWyx = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzWyx.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzZEb.add(dataRelation);
        }
        return this.zzZEb;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzWyx.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzQS;
    }

    public DataColumnCollection getColumns() {
        return this.zzYwy;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXiP;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzEN == null) {
            return new DataColumn[0];
        }
        return this.zzEN.getColumns();
    }

    final void zzWNj(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzEN != null) {
                this.zzEN.zzYzO(false);
                this.getConstraints().remove(this.zzEN);
                this.zzEN = null;
            }
            return;
        }
        if (this.zzEN != null && DataColumn.areColumnSetsTheSame(value, this.zzEN.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXMZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzEN != null) {
            this.zzEN.zzYzO(false);
            this.getConstraints().remove(this.zzEN);
            this.zzEN = null;
        }
        UniqueConstraint.zzXMZ(this.getConstraints(), uniqueConstraint);
        this.zzEN = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzJB;
    }

    public void setNamespace(String namespace) {
        this.zzJB = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzVYa;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzVYa = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzu1.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzZTj.zzXMZ(this.getResultSet(), this);
            zzZTj.zzZTj(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zz14.zzjA(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzZTj.zzXk3(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzZg7.contains(listener)) {
            this.zzZg7.add(listener);
        }
    }

    public void removeEventListener(zz4c listener) {
        if (this.zzZg7.contains(listener)) {
            this.zzZg7.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzZg7.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzu1.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZg7) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzu1.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZg7) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzu1.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZg7) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZg7) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZg7) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzYIy zzXMZ(zzZTj[] zzZTjArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzZTjArray.length];
        for (int i = 0; i < zzZTjArray.length; ++i) {
            dataColumnArray[i] = zzZTjArray[i].zzXf8();
        }
        DataTable dataTable = this;
        zzYIy zzYIy2 = dataTable.zzYJF.zzjA(dataColumnArray);
        if (zzYIy2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzYIy2;
    }

    final zzWNj zzZcu() {
        return this.zzYJF;
    }

    final Set<DataRow> zzZ97() {
        return this.zzu1;
    }
}

