/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz14;
import com.aspose.words.internal.zzWEV;
import com.aspose.words.internal.zzX31;
import com.aspose.words.internal.zzXDW;
import com.aspose.words.internal.zzY65;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzZTj;
import com.aspose.words.net.System.Data.zzjA;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzYrd;
    private Object[] zzWxm;
    private int zzZgt = 1;
    private int zzW3e;
    private String zzYDo;
    private Map<String, Object> zzW6i = new HashMap<String, Object>();
    private Map<String, String> zzNA = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzYrd = table;
        this.zzWxm = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzWxm, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzZTj.zz4c(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzYrd.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzYrd.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzYrd;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzYrd.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzYrd.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzYrd.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzYrd.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzYrd.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzYrd.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzYrd) {
            throw new IllegalStateException(zzX31.zzZTj("Table {0} is not the child table in the relation {1}", this.zzYrd.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzXMZ(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzVT1(columnIndex, value);
        this.zzYrd.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzYrd.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzZgt;
    }

    public void setRowState(int state) {
        this.zzZgt = state;
    }

    public void delete() {
        zzjA.zzZTj(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzW6i.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzW6i.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzWxm.length];
        System.arraycopy(this.zzWxm, 0, objectArray, 0, this.zzWxm.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzWxm.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzWxm.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzVT1(i, array[i]);
        }
        this.zzYrd.onDataRowChanged(this);
    }

    final int zzVYj() {
        return this.zzW3e;
    }

    final void zzZet(String string, String string2) {
        this.zzNA.put(string, string2);
    }

    final void zzYrX(String string, String string2) {
        this.zzYDo = zzX31.zzZTj(string, string2);
    }

    final String zzYZh() {
        return this.zzYDo;
    }

    final void zziL(int n) {
        this.zzW3e = n;
    }

    final Object[] zzZjW() {
        return this.zzWxm;
    }

    static boolean zzXMZ(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzXO5(index)) {
            return null;
        }
        return this.zzWxm[index];
    }

    private void zzVT1(int n, Object object) {
        if (!this.zzXO5(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzXMZ((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzXMZ((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzXMZ(clazz, object)))));
        this.zzWxm[n] = object2;
    }

    private static Object zzXMZ(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzY65.class) {
                return zzY65.zzXMZ(string, zzWEV.zzWoo(), 128).zzVZe();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zz14.zz4c(exception);
        }
        return object;
    }

    private boolean zzXO5(int n) {
        this.zzYzX();
        return this.zzWxm != null && n >= 0 && n < this.zzWxm.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzYrd.getColumns().getCount();
        if (this.zzWxm.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWxm.length - index];
        System.arraycopy(this.zzWxm, index, objectArray, 0, this.zzWxm.length - index);
        System.arraycopy(objectArray, 1, this.zzWxm, index, objectArray.length - 1);
    }

    private void zzYzX() {
        if (this.zzYrd == null || this.zzYrd.getColumns() == null || this.zzWxm == null) {
            return;
        }
        int n = this.zzYrd.getColumns().getCount();
        if (this.zzWxm.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWxm.length];
        System.arraycopy(this.zzWxm, 0, objectArray, 0, this.zzWxm.length);
        this.zzWxm = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzWxm.length);
        System.arraycopy(objectArray, 0, this.zzWxm, 0, n2);
        for (int i = n2; i < this.zzWxm.length; ++i) {
            this.zzWxm[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzXMZ(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block11;
            return null;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzXDW.zzXMZ(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zz14.zz4c(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zz14.zz4c(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zz14.zz4c(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zz14.zz4c(iOException);
            }
            return byArray;
        }
    }

    private static String zzXMZ(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zz14.zz4c(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zz14.zz4c(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzWxm;
        int n = dataRow.zzWxm.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

