/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzX31;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzZqE = new ArrayList();
    private final Map<String, DataColumn> zzZos = new HashMap<String, DataColumn>();
    private DataTable zzYrd;

    DataColumnCollection(DataTable table) {
        this.zzYrd = table;
    }

    public void add(DataColumn column) {
        if (zzX31.zz6J(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzVVp(column.getColumnName());
        if (this.zzZos.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzjA(this.zzYrd);
        column.setOrdinal(this.zzZqE.size());
        this.zzZqE.add(column);
        this.zzZos.put(string, column);
        this.zzYrd.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYrd);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYrd);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzX31.zz6J(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzVVp(columnName);
        DataColumn dataColumn = this.zzZos.get(string);
        if (dataColumn != null) {
            int n = this.zzZqE.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzZqE.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzZqE.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzZqE.remove(n);
            this.zzZos.remove(DataColumnCollection.zzVVp(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYrd.getRows()) {
                dataRow.remove(n);
            }
            this.zzYrd.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzZqE.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzZqE.iterator();
    }

    public void clear() {
        this.zzZos.clear();
        this.zzZqE.clear();
    }

    final DataColumn[] zzW1F() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzZqE);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXMZ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzZqE.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzZqE.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzVVp(string);
            String string3 = DataColumnCollection.zzVVp(dataColumn.getColumnName());
            this.zzZos.remove(string3);
            this.zzZos.put(string2, dataColumn);
            return;
        }
    }

    private static String zzVVp(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

