/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzGf;
import com.aspose.words.internal.zzWRy;
import com.aspose.words.internal.zzWlT;
import com.aspose.words.internal.zzX2S;
import com.aspose.words.internal.zzXhs;
import com.aspose.words.internal.zzXnQ;
import com.aspose.words.internal.zzYJB;
import com.aspose.words.internal.zzZLT;
import com.aspose.words.internal.zzZWl;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzYv7
extends CertPathBuilderSpi {
    private final zzZLT zzVTO;
    private zzXhs zzUr;

    zzYv7(zzZLT zzZLT2) {
        this.zzVTO = zzZLT2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZWl pkixParams;
        if (params instanceof zzZWl) {
            pkixParams = (zzZWl)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZWl.zzXMZ((PKIXBuilderParameters)params).zzZlZ();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZWl.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzWlT zzWlT2 = pkixParams.zzXaT().zzYAj();
        try {
            collection = zzYJB.zzXMZ(zzWlT2, pkixParams.zzXaT().zzXE2());
            collection.addAll(zzYJB.zzXMZ(zzWlT2, pkixParams.zzXaT().zzYxY()));
        }
        catch (zzXhs zzXhs2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXhs2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzXMZ(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzUr != null) {
            throw new CertPathBuilderException(this.zzUr.getMessage(), this.zzUr.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzXMZ(X509Certificate x509Certificate, zzZWl zzZWl2, List list) throws CertPathBuilderException {
        zzWRy zzWRy2;
        zzXnQ zzXnQ2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZWl2.zzZjm().contains(x509Certificate)) {
            return null;
        }
        if (zzZWl2.zzXH4() != -1 && list.size() - 1 > zzZWl2.zzXH4()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzXnQ2 = new zzXnQ(this.zzVTO);
            zzWRy2 = new zzWRy(this.zzVTO);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzYJB.zzXMZ(x509Certificate, zzZWl2.zzXaT().zzBc(), zzZWl2.zzXaT().zzYhx()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzXnQ2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXhs("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWRy2.engineValidate(certPath, zzZWl2);
                }
                catch (Exception exception) {
                    throw new zzXhs("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzX2S> arrayList = new ArrayList<zzX2S>();
            arrayList.addAll(zzZWl2.zzXaT().zzXE2());
            try {
                arrayList.addAll(zzYJB.zzXMZ(x509Certificate.getExtensionValue(zzGf.zzYij.getId()), zzZWl2.zzXaT().zzZt2()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXhs("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzYJB.zzXMZ(x509Certificate, zzZWl2.zzXaT().zzYxY(), arrayList));
            }
            catch (zzXhs zzXhs2) {
                throw new zzXhs("Cannot find issuer certificate for certificate in certification path.", zzXhs2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXhs("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzXMZ(x509Certificate2, zzZWl2, list);
            }
        }
        catch (zzXhs zzXhs3) {
            this.zzUr = zzXhs3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

