/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWlL;
import com.aspose.words.internal.zzX31;
import com.aspose.words.internal.zzYQ7;
import com.aspose.words.internal.zzYRc;
import com.aspose.words.internal.zzYyE;
import com.aspose.words.internal.zzZp6;
import com.aspose.words.internal.zzmz;
import com.aspose.words.zzeI;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzYlK;
    private zzeI zzX8H;

    Watermark(Document doc, zzeI watermarkProvider) {
        this.zzYlK = doc;
        this.zzX8H = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzYNL(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXMZ(text, textWatermarkOptions, this.zzYlK);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWlL.zzZTj((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzYlK, 75);
        shape.getImageData().setImage(image);
        this.zzXMZ(shape, options, this.zzYlK);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWlL.zzZTj((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzYlK, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXMZ(shape, options, this.zzYlK);
    }

    public final int getType() {
        Shape shape = this.zzX8H.get();
        if (shape == null) {
            return 2;
        }
        shape.zzZXc();
        if (shape.zzyr()) {
            return 0;
        }
        if (shape.zzX7l()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzX8H.add(shape);
    }

    public final void remove() {
        this.zzX8H.remove();
    }

    private static void zzYNL(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzYRc.zzVVQ(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWlL.zzXMZ(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXMZ(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzZTj(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXk3(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzZTj(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzRt() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzBb()) / d2) > (double)(f = pageSetup.zzZeK())) {
            d = (double)f / d3;
        }
        shape.zzYsW(zzYQ7.zz4c(d2 * d, 2, zzZp6.zzZRI));
        shape.zzWY4(zzYQ7.zz4c(d3 * d, 2, zzZp6.zzZRI));
    }

    private Shape zzXMZ(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXMZ(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXk3(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXMZ(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzWLN() ? 1.0f : textWatermarkOptions.getFontSize();
        zzmz zzmz2 = document.zzYAn().zz4c(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzmz2.zzzM(shape.getTextPath().getText());
        if (textWatermarkOptions.zzWLN()) {
            l = Watermark.zzXMZ(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzYsW(zzYQ7.zz4c(Float.intBitsToFloat(n), 2, zzZp6.zzZRI));
        shape.zzWY4(zzYQ7.zz4c(zzYyE.zzWdq(l), 2, zzZp6.zzZRI));
    }

    private static long zzXMZ(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzBb();
        float f2 = pageSetup.zzZeK();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYyE.zzWdq(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYyE.zzZuT(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYyE.zzWdq(l) >= Float.intBitsToFloat(n)) {
            return zzYyE.zzZuT(f2 / f3, f2);
        }
        float f6 = f;
        return zzYyE.zzZuT(f6, f6 * f3);
    }

    private static void zzXk3(Shape shape, String string) {
        shape.setName(zzX31.zzZTj("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

